// Matrixuhr-Mini, Scott-Falk Hühn, "functions.h"
// Funktionen

// Definitionen für das Matrix-Display
#define CMD_NOOP            0x00                                      // MAX7219-Kommando No Operation
#define CMD_DIGIT0          0x01                                      // MAX7219-Kommando Digit Line 0
#define CMD_DECODEMODE      0x09                                      // MAX7219-Kommando Decode Mode
#define CMD_INTENSITY       0x0a                                      // MAX7219-Kommando Intensity
#define CMD_SCANLIMIT       0x0b                                      // MAX7219-Kommando Scan Limit
#define CMD_SHUTDOWN        0x0c                                      // MAX7219-Kommando Shutdown
#define CMD_DISPLAYTEST     0x0f                                      // MAX7219-Kommando Display Test
#define PAR_NOOP            0x00                                      // MAX7219-Parameter No Operation
#define PAR_SHUTDOWN_ON     0x00                                      // MAX7219-Parameter Shutdown on
#define PAR_SHUTDOWN_OFF    0x01                                      // MAX7219-Parameter Shutdown off
#define PAR_DISPLAYTEST_OFF 0x00                                      // MAX7219-Parameter Display Test off
#define PAR_SCANLIMIT_7     0x07                                      // MAX7219-Parameter Scan Limit 7
#define PAR_DECODEMODE_NO   0x00                                      // MAX7219-Parameter Decode Mode No Decode
#define PAR_INTENSITY_0     0x00                                      // MAX7219-Parameter Intensity 0

// MAX7219-Kaskade initialisieren, beide Matrix-Module werden gleichzeitig bearbeitet
void matrix_init() {                                                  // keine Parameter
  uint8_t i;                                                          // Zählervariable

  digitalWrite(SPI_CS1_PIN, LOW);                                     // SPI-Transfer auf oberer Matrix beginnen
  digitalWrite(SPI_CS2_PIN, LOW);                                     // SPI-Transfer auf unterer Matrix beginnen
  SPI.transfer16(CMD_NOOP * 256 + PAR_NOOP);                          // Dummy-Ausgabe
  digitalWrite(SPI_CS1_PIN, HIGH);                                    // SPI-Transfer auf oberer Matrix beenden
  digitalWrite(SPI_CS2_PIN, HIGH);                                    // SPI-Transfer auf unterer Matrix beenden
  delay(5);                                                           // kurze Verzögerung

  digitalWrite(SPI_CS1_PIN, LOW);                                     // SPI-Transfer auf oberer Matrix beginnen
  digitalWrite(SPI_CS2_PIN, LOW);                                     // SPI-Transfer auf unterer Matrix beginnen
  for (i = 0; i < 4; i ++) {                                          // Sequenz an 4 Display-Module ausgeben
    SPI.transfer16(CMD_DISPLAYTEST * 256 + PAR_DISPLAYTEST_OFF);      // Kommando Displaytest off
  }
  digitalWrite(SPI_CS1_PIN, HIGH);                                    // SPI-Transfer auf oberer Matrix beenden
  digitalWrite(SPI_CS2_PIN, HIGH);                                    // SPI-Transfer auf unterer Matrix beenden
  digitalWrite(SPI_CS1_PIN, LOW);                                     // SPI-Transfer auf oberer Matrix beginnen
  digitalWrite(SPI_CS2_PIN, LOW);                                     // SPI-Transfer auf unterer Matrix beginnen
  for (i = 0; i < 4; i ++) {                                          // Sequenz an 4 Display-Module ausgeben
    SPI.transfer16(CMD_SCANLIMIT * 256 + PAR_SCANLIMIT_7);            // Kommando Scan Limit 7 Zeilen
  }
  digitalWrite(SPI_CS1_PIN, HIGH);                                    // SPI-Transfer auf oberer Matrix beenden
  digitalWrite(SPI_CS2_PIN, HIGH);                                    // SPI-Transfer auf unterer Matrix beenden
  digitalWrite(SPI_CS1_PIN, LOW);                                     // SPI-Transfer auf oberer Matrix beginnen
  digitalWrite(SPI_CS2_PIN, LOW);                                     // SPI-Transfer auf unterer Matrix beginnen
  for (i = 0; i < 4; i ++) {                                          // Sequenz an 4 Display-Module ausgeben
    SPI.transfer16(CMD_DECODEMODE * 256 + PAR_DECODEMODE_NO);         // Kommando Decode Mode No Decode
  }
  digitalWrite(SPI_CS1_PIN, HIGH);                                    // SPI-Transfer auf oberer Matrix beenden
  digitalWrite(SPI_CS2_PIN, HIGH);                                    // SPI-Transfer auf unterer Matrix beenden
  digitalWrite(SPI_CS1_PIN, LOW);                                     // SPI-Transfer auf oberer Matrix beginnen
  digitalWrite(SPI_CS2_PIN, LOW);                                     // SPI-Transfer auf unterer Matrix beginnen
  for (i = 0; i < 4; i ++) {                                          // Sequenz an 4 Display-Module ausgeben
    SPI.transfer16(CMD_INTENSITY * 256 + PAR_INTENSITY_0);            // Kommando Intensity 0
  }
  digitalWrite(SPI_CS1_PIN, HIGH);                                    // SPI-Transfer auf oberer Matrix beenden
  digitalWrite(SPI_CS2_PIN, HIGH);                                    // SPI-Transfer auf unterer Matrix beenden
  digitalWrite(SPI_CS1_PIN, LOW);                                     // SPI-Transfer auf oberer Matrix beginnen
  digitalWrite(SPI_CS2_PIN, LOW);                                     // SPI-Transfer auf unterer Matrix beginnen
  for (i = 0; i < 4; i ++) {                                          // Sequenz an 4 Display-Module ausgeben
    SPI.transfer16(CMD_SHUTDOWN * 256 + PAR_SHUTDOWN_OFF);            // Kommando Shutdown off
  }
  digitalWrite(SPI_CS1_PIN, HIGH);                                    // SPI-Transfer auf oberer Matrix beenden
  digitalWrite(SPI_CS2_PIN, HIGH);                                    // SPI-Transfer auf unterer Matrix beenden
}

// MAX7219-Kaskade reinitialisieren, beide Matrix-Module werden gleichzeitig bearbeitet
void matrix_reinit() {                                                // keine Parameter
  uint8_t i;                                                          // Zählervariable

  digitalWrite(SPI_CS1_PIN, LOW);                                     // SPI-Transfer auf oberer Matrix beginnen
  digitalWrite(SPI_CS2_PIN, LOW);                                     // SPI-Transfer auf unterer Matrix beginnen
  for (i = 0; i < 4; i ++) {                                          // Sequenz an 4 Display-Module ausgeben
    SPI.transfer16(CMD_DISPLAYTEST * 256 + PAR_DISPLAYTEST_OFF);      // Kommando Displaytest off
  }
  digitalWrite(SPI_CS1_PIN, HIGH);                                    // SPI-Transfer auf oberer Matrix beenden
  digitalWrite(SPI_CS2_PIN, HIGH);                                    // SPI-Transfer auf unterer Matrix beenden
  digitalWrite(SPI_CS1_PIN, LOW);                                     // SPI-Transfer auf oberer Matrix beginnen
  digitalWrite(SPI_CS2_PIN, LOW);                                     // SPI-Transfer auf unterer Matrix beginnen
  for (i = 0; i < 4; i ++) {                                          // Sequenz an 4 Display-Module ausgeben
    SPI.transfer16(CMD_SCANLIMIT * 256 + PAR_SCANLIMIT_7);            // Kommando Scan Limit 7 Zeilen
  }
  digitalWrite(SPI_CS1_PIN, HIGH);                                    // SPI-Transfer auf oberer Matrix beenden
  digitalWrite(SPI_CS2_PIN, HIGH);                                    // SPI-Transfer auf unterer Matrix beenden
  digitalWrite(SPI_CS1_PIN, LOW);                                     // SPI-Transfer auf oberer Matrix beginnen
  digitalWrite(SPI_CS2_PIN, LOW);                                     // SPI-Transfer auf unterer Matrix beginnen
  for (i = 0; i < 4; i ++) {                                          // Sequenz an 4 Display-Module ausgeben
    SPI.transfer16(CMD_DECODEMODE * 256 + PAR_DECODEMODE_NO);         // Kommando Decode Mode No Decode
  }
  digitalWrite(SPI_CS1_PIN, HIGH);                                    // SPI-Transfer auf oberer Matrix beenden
  digitalWrite(SPI_CS2_PIN, HIGH);                                    // SPI-Transfer auf unterer Matrix beenden
  digitalWrite(SPI_CS1_PIN, LOW);                                     // SPI-Transfer auf oberer Matrix beginnen
  digitalWrite(SPI_CS2_PIN, LOW);                                     // SPI-Transfer auf unterer Matrix beginnen
  for (i = 0; i < 4; i ++) {                                          // Sequenz an 4 Display-Module ausgeben
    SPI.transfer16(CMD_INTENSITY * 256 + brightval);                  // Kommando Intensity - aktuelle Helligkeit
  }
  digitalWrite(SPI_CS1_PIN, HIGH);                                    // SPI-Transfer auf oberer Matrix beenden
  digitalWrite(SPI_CS2_PIN, HIGH);                                    // SPI-Transfer auf unterer Matrix beenden
  digitalWrite(SPI_CS1_PIN, LOW);                                     // SPI-Transfer auf oberer Matrix beginnen
  digitalWrite(SPI_CS2_PIN, LOW);                                     // SPI-Transfer auf unterer Matrix beginnen
  for (i = 0; i < 4; i ++) {                                          // Sequenz an 4 Display-Module ausgeben
    SPI.transfer16(CMD_SHUTDOWN * 256 + PAR_SHUTDOWN_OFF);            // Kommando Shutdown off
  }
  digitalWrite(SPI_CS1_PIN, HIGH);                                    // SPI-Transfer auf oberer Matrix beenden
  digitalWrite(SPI_CS2_PIN, HIGH);                                    // SPI-Transfer auf unterer Matrix beenden
}

// MAX7219-Kaskade ausschalten, beide Matrix-Module werden gleichzeitig bearbeitet
void matrix_off() {                                                   // keine Parameter
  uint8_t i;                                                          // Zählervariable

  digitalWrite(SPI_CS1_PIN, LOW);                                     // SPI-Transfer auf oberer Matrix beginnen
  digitalWrite(SPI_CS2_PIN, LOW);                                     // SPI-Transfer auf unterer Matrix beginnen
  for (i = 0; i < 4; i ++) {                                          // Sequenz an 4 Display-Module ausgeben
    SPI.transfer16(CMD_SHUTDOWN * 256 + PAR_SHUTDOWN_ON);             // Kommando Shutdown on
  }
  digitalWrite(SPI_CS1_PIN, HIGH);                                    // SPI-Transfer auf oberer Matrix beenden
  digitalWrite(SPI_CS2_PIN, HIGH);                                    // SPI-Transfer auf unterer Matrix beenden
}

// Matrix-Daten auf MAX7219-Kaskade ausgeben
void matrix_send(uint8_t m) {                                         // m: Matrix-Nummer (0 = obere Display-Matrix, 1 = untere Display-Matrix)
  uint8_t i;                                                          // Zählervariable
  uint8_t z;                                                          // Zeilenzähler
  uint8_t cs_pin;                                                     // Zwischenspeicher für SPI-CS-Pin

  if (m > 1) return;                                                  // wenn ungültige Matrix-Nummer -> Ende
  if (m) cs_pin = SPI_CS2_PIN;                                        // wenn untere Display-Matrix -> SPI-CS-Pin für untere Matrix verwenden
  else cs_pin = SPI_CS1_PIN;                                          // sonst SPI-CS-Pin für obere Matrix verwenden
  for (z = 0; z < 8; z ++) {                                          // 8 Display-Zeilen ausgeben
    digitalWrite(cs_pin, LOW);                                        // SPI-Transfer beginnen
    for (i = 0; i < 4; i ++) {                                        // Daten an 4 Display-Module ausgeben
      SPI.transfer16((CMD_DIGIT0 + z) * 256 + matrix[m][z * 4 + 3 - i]); // Matrix-Zeile für ein Display-Modul ausgeben
    }
    digitalWrite(cs_pin, HIGH);                                       // SPI-Transfer beenden
  }
}

// Web-Server, übergebene Datei ist nicht vorhanden
void notFound(AsyncWebServerRequest *request) {
  request->send(404, "text/plain", "Seite nicht gefunden");           // Fehlertext ausgeben
}

// Timer-Funktionen, werden alle 40ms von loop() aufgerufen
void timer40ms() {
  uint8_t i;                                                          // Zählervariable
  uint16_t sum;                                                       // Summenwert für die Mittelwert-Berechnung

  if (boottout < 255) {                                               // wenn Reboot-Timeout-Zähler aktiv
    if (boottout > 0) boottout --;                                    // wenn Reboot-Timeout-Zähler noch nicht abgelaufen -> Timeout-Zähler vermindern
  }

  bright = analogRead(ADC_PIN) / 64;                                  // aktuellen ADC-Wert lesen und in Helligkeitswert umrechnen
  if (bright > 15) bright = 15;                                       // Maximalwert begrenzen
  britab[bripos ++] = bright;                                         // Helligkeitswert in Tabelle speichern und Position erhöhen
  if (bripos > 31) bripos = 0;                                        // wenn letzte Position überschritten -> zurücksetzen
  sum = 0;                                                            // Summe löschen
  for (i = 0; i < 32; i ++) sum += britab[i];                         // Summe ermitteln
  brightval = sum / 32;                                               // aktuellen Helligkeits-Mittelwert speichern
  if (brightval > 15) brightval = 15;                                 // wenn maximale Helligkeit überschritten -> begrenzen
}

// Timer-Funktionen, werden jede Sekunde von loop() aufgerufen
void timer1sec() {                                                    // Timeout-Zähler 1s verwalten
  
  if (wifitout < 255) {                                               // wenn WLAN-Timeout-Zähler aktiv
    if (wifitout > 0) wifitout --;                                    // wenn WLAN-Timeout-Zähler noch nicht abgelaufen -> Timeout-Zähler vermindern
  }
  if (mqtttout < 255) {                                               // wenn MQTT-Timeout-Zähler aktiv
    if (mqtttout > 0) mqtttout --;                                    // wenn MQTT-Timeout-Zähler noch nicht abgelaufen -> Timeout-Zähler vermindern
  }

  if (syncstat > 0) {                                                 // wenn Uhr synchronisiert
    nighttime = false;                                                // Nacht-Zeit-Flag zunächst löschen
    if (night_stim < night_etim) {                                    // wenn Beginnzeit < Endzeit
      if (hour >= night_stim && hour < night_etim) nighttime = true;  // wenn aktuelle Zeit innerhalb der Beginn- und Endzeit -> Nacht-Zeit-Flag setzen
    }
    if (night_stim > night_etim) {                                    // wenn Beginnzeit > Endzeit
      if (hour >= night_stim || hour < night_etim) nighttime = true;  // wenn aktuelle Zeit nach Beginnzeit oder vor Endzeit -> Nacht-Zeit-Flag setzen
    }
  }
  else nighttime = false;                                             // wenn Uhr nicht synchronisiert -> Nacht-Zeit-Flag löschen

  seccount ++;                                                        // Sekundenzähler erhöhen
  if (seccount > 59) {                                                // wenn Endwert (59) überschritten
    seccount = 0;                                                     // Sekundenzähler zurücksetzen, alle weiteren Teile dieser Funktion werden im Minutentakt abgearbeitet
    if (synctout < 255) {                                             // wenn Synchronisierungs-Timeout-Zähler aktiv
      if (synctout > 0) synctout --;                                  // wenn Synchronisierungs-Timeout-Zähler noch nicht abgelaufen -> Timeout-Zähler vermindern
    }
  }
}

// Alle Pixel einer Matrix löschen
void matrix_clear(uint8_t m) {                                        // m: Matrix-Nummer (0 = obere Display-Matrix, 1 = untere Display-Matrix)
  uint8_t i;                                                          // Zählervariable

  if (m > 1) return;                                                  // wenn ungültige Matrix-Nummer -> Ende
  for (i = 0; i < 32; i ++) {                                         // alle Matrix-Bytes bearbeiten
    matrix[m][i] = 0;                                                 // Matrix-Byte löschen
  }
}

// Ein Pixel in einer Matrix setzen
void matrix_setpixel(uint8_t m, uint8_t x, uint8_t y) {               // m: Matrix-Nummer (0 = obere Display-Matrix, 1 = untere Display-Matrix), x: Position X (0-31), y: Position Y (0-7)

  if (m > 1) return;                                                  // wenn ungültige Matrix-Nummer -> Ende
  if (x < 32 && y < 8) {                                              // wenn Positionen innerhalb der Matrix
    matrix[m][y * 4 + x / 8] = matrix[m][y * 4 + x / 8] | 1 << x % 8; // Pixel-Bit in der Matrix setzen
  }
}

// Ausgabe einer Ziffer für die Zeitanzeige ohne Sekunden in die Matrix (Verwendung der Großziffern mit fester Breite von 6 Pixel)
void matrix_digit(uint8_t m, uint8_t d) {                             // m: Matrix-Nummer (0 = obere Display-Matrix, 1 = untere Display-Matrix), d: auszugebende Ziffer (0-9)
  uint8_t offset;                                                     // Offset in der Zeichensatz-Tabelle
  uint8_t x;                                                          // Zähler für die Zeichenausgabe, X-Position
  uint8_t y;                                                          // Zähler für die Zeichenausgabe, Y-Position
  uint8_t b;                                                          // Zwischenspeicher für Bytes aus der Zeichensatz-Tabelle

  if (m > 1 || d > 9) return;                                         // wenn ungültige Matrix-Nummer oder ungültige Ziffer -> Ende
  offset = d * 6;                                                     // Tabellen-Offset berechnen
  for (x = 0; x < 6; x ++) {                                          // 6 Spalten ausgeben
    b = pgm_read_byte(&digit_array[offset ++]);                       // Spaltenbyte holen
    for (y = 0; y < 8; y ++) {                                        // Spaltenbyte bitweise ausgeben
      if (b & 0x80) matrix_setpixel(m, matrix_pos + x, y);            // wenn Pixel gesetzt werden muss -> LSB als Pixel ausgeben
      b <<= 1;                                                        // nächste Bit-Position an LSB
    }
  }
  matrix_pos += 7;                                                    // nächste Zeichenposition
}

// Ausgabe einer Ziffer für die Zeitanzeige mit Sekunden in die Matrix (Verwendung der Großziffern mit fester Breite von 4 Pixel)
void matrix_digit2(uint8_t m, uint8_t d) {                            // m: Matrix-Nummer (0 = obere Display-Matrix, 1 = untere Display-Matrix), d: auszugebende Ziffer (0-9)
  uint8_t offset;                                                     // Offset in der Zeichensatz-Tabelle
  uint8_t x;                                                          // Zähler für die Zeichenausgabe, X-Position
  uint8_t y;                                                          // Zähler für die Zeichenausgabe, Y-Position
  uint8_t b;                                                          // Zwischenspeicher für Bytes aus der Zeichensatz-Tabelle

  if (m > 1 || d > 9) return;                                         // wenn ungültige Matrix-Nummer oder ungültige Ziffer -> Ende
  offset = d * 4;                                                     // Tabellen-Offset berechnen
  for (x = 0; x < 4; x ++) {                                          // 4 Spalten ausgeben
    b = pgm_read_byte(&digit_array2[offset ++]);                      // Spaltenbyte holen
    for (y = 0; y < 8; y ++) {                                        // Spaltenbyte bitweise ausgeben
      if (b & 0x80) matrix_setpixel(m, matrix_pos + x, y);            // wenn Pixel gesetzt werden muss -> LSB als Pixel ausgeben
      b <<= 1;                                                        // nächste Bit-Position an LSB
    }
  }
  matrix_pos += 5;                                                    // nächste Zeichenposition
}

// Ausgabe eines Zeichens in die Matrix
void matrix_char(uint8_t m, char c) {                                 // m: Matrix-Nummer (0 = obere Display-Matrix, 1 = untere Display-Matrix), c: auszugebendes Zeichen (0-9)
  uint16_t offset;                                                    // Offset in der Zeichensatz-Tabelle
  uint8_t x;                                                          // Zähler für die Zeichenausgabe, X-Position
  uint8_t y;                                                          // Zähler für die Zeichenausgabe, Y-Position
  uint8_t b;                                                          // Zwischenspeicher für Bytes aus der Zeichensatz-Tabelle
  uint8_t w;                                                          // Zeichenbreite

  if (m > 1 || c < 32 || c > 126) return;                             // wenn ungültige Matrix-Nummer oder ungültiges Zeichen -> Ende
  offset = (c - 32) * 6;                                              // Tabellen-Offset berechnen
  w = pgm_read_byte(&font_array[offset ++]);                          // Zeichenbreite holen
  for (x = 0; x < w; x ++) {                                          // vom Zeichen genutzte Spalten ausgeben
    b = pgm_read_byte(&font_array[offset ++]);                        // Spaltenbyte holen
    for (y = 0; y < 8; y ++) {                                        // Spaltenbyte bitweise ausgeben
      if (b & 0x80) matrix_setpixel(m, matrix_pos + x, y);            // wenn Pixel gesetzt werden muss -> LSB als Pixel ausgeben
      b <<= 1;                                                        // nächste Bit-Position an LSB
    }
  }
  matrix_pos += w + 1;                                                // nächste Zeichenposition
}

// Ausgabe eines festen Strings in die Matrix
void matrix_str(uint8_t m, uint8_t strnr) {                           // m: Matrix-Nummer (0 = obere Display-Matrix, 1 = untere Display-Matrix), strnr: String-Nummer im Flash-Speicher
  uint8_t i = 0;                                                      // Zeichenzähler auf erstes Zeichen setzen
  strcpy_P(strbuf, (PGM_P) pgm_read_ptr(&stringsd[strnr]));           // String in den RAM-Puffer kopieren
  while (strbuf[i] > 0) matrix_char(m, strbuf[i ++]);                 // Schleife bis zum Endezeichen (0) -> Zeichen ausgeben
}

// Ausgabe der Uhrzeit
void matrix_time(uint8_t m, bool dots) {                              // m: Matrix-Nummer (0 = obere Display-Matrix, 1 = untere Display-Matrix)
                                                                      // dots: Ausgabe des Doppelpunktes mit aktuellem WLAN/Sync-Status (wenn true)
  uint8_t i;                                                          // Zählervariable

  if (m > 1) return;                                                  // wenn ungültige Matrix-Nummer -> Ende
  hour_h = hour / 10;                                                 // Stunden-Zehner ermitteln
  hour_l = hour % 10;                                                 // Stunden-Einer ermitteln
  minute_h = minute / 10;                                             // Minuten-Zehner ermitteln
  minute_l = minute % 10;                                             // Minuten-Einer ermitteln
  second_h = second / 10;                                             // Sekunden-Zehner ermitteln
  second_l = second % 10;                                             // Sekunden-Einer ermiteln
  matrix_clear(m);                                                    // Matrix-Puffer löschen

  if (dispsecs) {                                                     // wenn Zeitanzeige mit Sekunden
    matrix_pos = 0;
    if (hour_h > 0) matrix_digit2(m, hour_h);                         // wenn Stunden-Zehner ungleich 0 -> Stunden-Zehner ausgeben
    matrix_pos = 5;
    matrix_digit2(m, hour_l);                                         // Stunden-Einer ausgeben
    matrix_pos = 12;
    matrix_digit2(m, minute_h);                                       // Minuten-Zehner ausgeben
    matrix_digit2(m, minute_l);                                       // Minuten-Einer ausgeben
    matrix_pos = 23;
    matrix_digit2(m, second_h);                                       // Sekunden-Zehner ausgeben
    matrix_digit2(m, second_l);                                       // Sekunden-Einer ausgeben
    if (dots) {                                                       // wenn Ausgabe des Doppelpunktes erforderlich
      if (wifistat < 2) {                                             // wenn keine WLAN-Verbindung
        for (i = 2; i < 6; i ++) {                                    // Spaltenreihe mit 4 Pixel ausgeben
          matrix_setpixel(m, 10, i);                                  // Pixel-Spalte ausgeben
        }
      }
      else {                                                          // wenn WLAN-Verbindung vorhanden
        if (syncstat > 0) {                                           // wenn Zeit vorhanden
          matrix_setpixel(m, 10, 2);
          matrix_setpixel(m, 10, 5);
        }
        else {                                                        // wenn keine Zeit vorhanden
          matrix_setpixel(m, 10, 3);                                  // kompakten Punkt anzeigen
          matrix_setpixel(m, 10, 4);
        }
      }
    }
  }
  else {                                                              // wenn Zeitanzeige ohne Sekunden
    matrix_pos = 1;
    if (hour_h > 0) matrix_digit(m, hour_h);                          // wenn Stunden-Zehner ungleich 0 -> Stunden-Zehner ausgeben
    matrix_pos = 8;
    matrix_digit(m, hour_l);                                          // Stunden-Einer ausgeben
    matrix_pos = 18;
    matrix_digit(m, minute_h);                                        // Minuten-Zehner ausgeben
    matrix_digit(m, minute_l);                                        // Minuten-Einer ausgeben
    if (dots) {                                                       // wenn Ausgabe des Doppelpunktes erforderlich
      if (wifistat < 2) {                                             // wenn keine WLAN-Verbindung
        for (i = 2; i < 6; i ++) {                                    // Spaltenreihen mit jeweils 4 Pixel ausgeben
          matrix_setpixel(m, 15, i);                                  // Pixel-Spalte ausgeben
          matrix_setpixel(m, 16, i);                                  // Pixel-Spalte ausgeben
        }
      }
      else {                                                          // wenn WLAN-Verbindung vorhanden
        if (syncstat > 0) {                                           // wenn Zeit vorhanden
          matrix_setpixel(m, 15, 2);                                  // normalen Doppelpunkt ausgeben
          matrix_setpixel(m, 15, 5);
          matrix_setpixel(m, 16, 2);
          matrix_setpixel(m, 16, 5);
        }
        else {                                                        // wenn keine Zeit vorhanden
          matrix_setpixel(m, 15, 3);                                  // kompakten Punkt anzeigen
          matrix_setpixel(m, 15, 4);
          matrix_setpixel(m, 16, 3);
          matrix_setpixel(m, 16, 4);
        }
      }
    }
  }
}

// Matrix-Daten um ein Pixel nach links verschieben und eine Pixelspalte aus dem Pixelpuffer ergänzen
void matrix_shift(uint8_t m) {                                        // m: Matrix-Nummer (0 = obere Display-Matrix, 1 = untere Display-Matrix)
  uint8_t i;                                                          // Zählervariable
  uint8_t z;                                                          // Zeilenzähler
  uint8_t a, b, c;                                                    // Zwischenspeicher

  if (m > 1) return;                                                  // wenn ungültige Matrix-Nummer -> Ende
  if (pbuff_rpos >= 0) c = pixelbuff[pbuff_rpos];                     // wenn Leseposition auf Pixelpuffer zeigt -> Pixelzeile holen
  else c = 0;                                                         // sonst 0-Bits
  for (z = 0; z < 8; z ++) {                                          // 8 Display-Zeilen bearbeiten
    for (i = 0; i < 4; i ++) {                                        // 4 Zeilen-Bytes verschieben
      a = (matrix[m][z * 4 + i] >> 1) & 0x7f;                         // Byte holen, um eine Position nach rechts verschieben und Bit 7 löschen
      if (i < 3) b = (matrix[m][z * 4 + i + 1] << 7) & 0x80;          // wenn rechtes Nachbar-Byte vorhanden -> holen, um 7 Positionen nach links verschieben und Bit 7 filtern
      else b = c & 0x80;                                              // ohne Nachbar -> zwischengespeichertes Pixel aus Pixelpuffer verwenden (Bit 7)
      matrix[m][z * 4 + i] = a | b;                                   // gefiltertes Nachbar-Bit einfügen und Byte wieder speichern
    }
    c <<= 1;                                                          // nächstes Pixel nach Bit 7 schieben
  }
}

// Ausgabe eines Zeichens in den Pixelpuffer
void pbuff_char(char c) {                                             // c: auszugebendes ASCII Zeichen (>= 0x20)
  uint16_t offset;                                                    // Offset in der Zeichensatz-Tabelle
  uint8_t x;                                                          // Zähler für die Zeichenausgabe, X-Position
  uint8_t w;                                                          // Zeichenbreite

  if (c < 32) return;                                                 // wenn ungültiger Zeichencode -> Ende
  offset = (c - 32) * 6;                                              // Tabellen-Offset berechnen
  w = pgm_read_byte(&font_array[offset ++]);                          // Zeichenbreite holen
  if (pbuff_wpos + w < PBUFFSIZE) {                                   // wenn Zeichen noch in den Pixelpuffer passt
    for (x = 0; x < w; x ++) {                                        // vom Zeichen genutzte Spalten ausgeben
      pixelbuff[pbuff_wpos ++] = pgm_read_byte(&font_array[offset ++]); // Spaltenbyte holen und direkt in den Pixelpuffer schreiben
    }
  }
  pixelbuff[pbuff_wpos ++] = 0;                                       // Leerraum löschen und auf nächste Position setzen
}

// Ausgabe eines Symbols in den Pixelpuffer
void pbuff_symb(char s) {                                             // s: auszugebendes Symbol
  uint16_t offset;                                                    // Offset in der Zeichensatz-Tabelle
  uint8_t x;                                                          // Zähler für die Zeichenausgabe, X-Position
  uint8_t w;                                                          // Zeichenbreite

  offset = s * 17;                                                    // Tabellen-Offset berechnen
  w = pgm_read_byte(&symbol_array[offset ++]);                        // Zeichenbreite holen
  if (pbuff_wpos + w < PBUFFSIZE) {                                   // wenn Zeichen noch in den Pixelpuffer passt
    for (x = 0; x < w; x ++) {                                        // vom Zeichen genutzte Spalten ausgeben
      pixelbuff[pbuff_wpos ++] = pgm_read_byte(&symbol_array[offset ++]); // Spaltenbyte holen und direkt in den Pixelpuffer schreiben
    }
  }
  pixelbuff[pbuff_wpos ++] = 0;                                       // Leerraum löschen und auf nächste Position setzen
}

// Ausgabe eines festen Strings in den Pixelpuffer
void pbuff_str(uint8_t strnr) {                                       // strnr: String-Nummer im Flash-Speicher
  uint8_t i = 0;                                                      // Zeichenzähler auf erstes Zeichen setzen

  strcpy_P(strbuf, (PGM_P) pgm_read_ptr(&stringsd[strnr]));           // String in den RAM-Puffer kopieren
  while (strbuf[i] > 0) pbuff_char(strbuf[i ++]);                     // Schleife bis zum Endezeichen (0) -> Zeichen ausgeben
}

// Ausgabe eines Wetterlagentextes in den Pixelpuffer
void pbuff_wcstr(uint8_t wcsnr) {                                     // wcsnr: Wetterlagentext-Nummer
  uint8_t i = 4;                                                      // Zeichenzähler auf Textanfang setzen

  strcpy_P(strbuf, (PGM_P) pgm_read_ptr(&wcstringsd[wcsnr]));         // Wetterlagentext in den String-Puffer kopieren
  while (strbuf[i] > 0) pbuff_char(strbuf[i ++]);                     // Schleife bis zum Endezeichen (0) -> Zeichen ausgeben
}

// Prozentzeichen für die Web-Ausgabe maskieren, vermeidet Probleme mit dem Platzhalterzeichen % des Web-Servers
String percentmask(String sin) {                                      // sin: zu bearbeitender String
  uint8_t i;                                                          // Zählervariable
  String sout;                                                        // bearbeiteter String
  for (i = 0; i < sin.length(); i ++) {                               // alle Zeichen des Strings bearbeiten
    if (sin[i] == '%') sout += "&#37;";                               // wenn Prozentzeichen gefunden -> durch HTML-Code ersetzen
    else sout += sin[i];                                              // sonst Zeichen unverändert übernehmen
  }
  return sout;                                                        // bearbeiteten String zurückgeben
}

// Strings für die Laufzeit-Anzeige erstellen
void uptime_strings() {
  sprintf(uptime, "%.2f", (float) uptime_m / 24 / 60);                // Systemlaufzeit für MQTT-Ausgabe erstellen
  if (uptime_m < 60) {                                                // dynamische Systemlaufzeit für Web-Seite, wenn Zeit < 1 Stunde
    if (uptime_m == 1) sprintf(uptimex, "%lu Minute", uptime_m);      // wenn Zeit = eine Minute -> Minute ausgeben
    else sprintf(uptimex, "%lu Minuten", uptime_m);                   // sonst Minuten ausgeben
  }
  else {                                                              // wenn Zeit >= 1 Stunde
    if (uptime_m < 24 * 60) sprintf(uptimex, "%.1f Stunden", (float) uptime_m / 60); // wenn Zeit < 1 Tag -> Stunden ausgeben
    else sprintf(uptimex, "%.2f Tage", (float) uptime_m / 24 / 60);   // sonst Tage ausgeben
  }
}

// Schreiben einer Konfigurationsdatei in das Dateisystem
bool write_cfgfile(String filename, uint8_t lines) {                  // filename: Dateiname, lines: Anzahl der zu schreibenden Zeilen
  uint8_t linecnt;                                                    // Zeilenzähler

  if (filestat) {                                                     // wenn Dateisystem ok
    File cfgfile = LittleFS.open(filename, "w");                      // Datei zum Schreiben öffnen
    for (linecnt = 0; linecnt < lines; linecnt ++) {                  // Schleife zum Schreiben der Zeilen
      cfgfile.println(filedata[linecnt]);                             // eine Zeile schreiben
    }
    cfgfile.close();                                                  // Datei schließen
    return true;                                                      // Schreiben war erfolgreich
  }
  else return false;                                                  // Dateisystemfehler -> Schreiben war nicht erfolgreich
}

// Lesen einer Konfigurationsdatei aus dem Dateisystem
bool read_cfgfile(String filename, uint8_t lines) {                   // filename: Dateiname, lines: Anzahl der zu lesenden Zeilen
  String readstr = "";                                                // String-Zwischenspeicher
  char readchar;                                                      // Zeichen-Zwischenspeicher
  uint8_t linecnt = 0;                                                // Zeilenzähler
  uint8_t i;                                                          // Schleifenzähler

  for (i = 0; i < FILEDATA; i ++) filedata[i] = "";                   // Dateipuffer löschen
  if (filestat) {                                                     // wenn Dateisystem ok
    if (lines > FILEDATA) lines = FILEDATA;                           // Zeilenanzahl auf verfügbare Pufferzeilen begrenzen
    File cfgfile = LittleFS.open(filename, "r");                      // Datei zum Lesen öffnen
    if (cfgfile) {                                                    // wenn Datei vorhanden
      while (cfgfile.available() && (linecnt < lines)) {              // Schleife bis alle Daten gelesen sind
        readchar = cfgfile.read();                                    // einzelnes Zeichen aus Datei lesen
        if (readchar >= 32) readstr += readchar;                      // wenn kein Steuerzeichen -> an String-Zwischenspeicher anhängen
        if (readchar == '\n') {                                       // wenn Zeilenende (LF/10)
          filedata[linecnt] = readstr;                                // Zeile in Dateipuffer speichern
          readstr = "";                                               // String-Zwischenspeicher wieder löschen
          linecnt ++;                                                 // nächste Zeile
        }
      }
      cfgfile.close();                                                // Datei schließen
      return true;                                                    // Lesen war erfolgreich
    }
    else return false;                                                // Datei nicht vorhanden -> Lesen war nicht erfolgreich
  }
  else return false;                                                  // Dateisystemfehler -> Lesen war nicht erfolgreich
}

// Schreiben der Geburtstagliste in das Dateisystem
bool write_bdayfile() {
  uint8_t linecnt;                                                    // Zeilenzähler

  if (filestat) {                                                     // wenn Dateisystem ok
    File bdayfile = LittleFS.open(bday_filename, "w");                // Geburtstagsdatei zum Schreiben öffnen
    for (linecnt = 0; linecnt < MAXBDAYS; linecnt ++) {               // Schleife zum Schreiben der Zeilen
      if (birthdays[linecnt] == "") break;                            // wenn leerer String -> Ende
      bdayfile.println(birthdays[linecnt]);                           // eine Zeile schreiben
    }
    bdayfile.close();                                                 // Geburtstagsdatei schließen
    return true;                                                      // Schreiben war erfolgreich
  }
  else return false;                                                  // Dateisystemfehler -> Schreiben war nicht erfolgreich
}

// Lesen der Geburtstagsliste aus dem Dateisystem
bool read_bdayfile() {
  String readstr = "";                                                // String-Zwischenspeicher
  char readchar;                                                      // Zeichen-Zwischenspeicher
  uint8_t linecnt = 0;                                                // Zeilenzähler
  uint8_t i;                                                          // Schleifenzähler

  for (i = 0; i < MAXBDAYS; i ++) birthdays[i] = "";                  // Geburtstagsliste löschen
  if (filestat) {                                                     // wenn Dateisystem ok
    File bdayfile = LittleFS.open(bday_filename, "r");                // Geburtstagsdatei zum Lesen öffnen
    if (bdayfile) {                                                   // wenn Datei vorhanden
      while (bdayfile.available() && (linecnt < MAXBDAYS)) {          // Schleife bis alle Daten gelesen sind
        readchar = bdayfile.read();                                   // einzelnes Zeichen aus Datei lesen
        if (readchar >= 32) readstr += readchar;                      // wenn kein Steuerzeichen -> an String-Zwischenspeicher anhängen
        if (readchar == '\n') {                                       // wenn Zeilenende (LF/10)
          birthdays[linecnt] = readstr;                               // Zeile in Geburtstagsliste speichern
          readstr = "";                                               // String-Zwischenspeicher wieder löschen
          linecnt ++;                                                 // nächste Zeile
        }
      }
      bdayfile.close();                                               // Geburtstagsdatei schließen
      return true;                                                    // Lesen war erfolgreich
    }
    else return false;                                                // Datei nicht vorhanden -> Lesen war nicht erfolgreich
  }
  else return false;                                                  // Dateisystemfehler -> Lesen war nicht erfolgreich
}

// Geburtstags-Datenfeld sortieren
void bdaysort() {
  int8_t i, j;                                                        // Zählervariablen
  String bdaytemp;                                                    // Zwischenspeicher für Geburtstagseintrag

  for (i = 0; i < MAXBDAYS; i ++) {                                   // Datenfeld neu organisieren: "jjjjmmtt Name" -> "mmttjjjj Name"
    if (birthdays[i] != "") {                                         // wenn Eintrag Daten enthält
      bdaytemp = birthdays[i].substring(4, 8) + birthdays[i].substring(0, 4) + birthdays[i].substring(8); // String umbauen und zwischenspeichern
      birthdays[i] = bdaytemp;                                        // geänderten Eintrag speichern
    }
    else birthdays[i] = "Z";                                          // wenn Eintrag keine Daten enthält -> Dummy-String setzen
  }
  for (j = MAXBDAYS - 1; j >= 0; j --) {                              // Bubblesort-Algorithmus, außere Schleife vom letzten Element bis 0
    for (i = 0; i < j; i ++) {                                        // innere Schleife von 0 bis zum Wert der äußeren Schleife
      if (birthdays[i] > birthdays[i + 1]) {                          // wenn größeres Element vor kleinerem Element -> tauschen
        bdaytemp = birthdays[i];                                      // größeres Element zwischenspeichern
        birthdays[i] = birthdays[i + 1];                              // kleineres Element eine Position nach unten
        birthdays[i + 1] = bdaytemp;                                  // zwischengespeichertes größeres Element nach hinten
      }
    }
  }
  for (i = 0; i < MAXBDAYS; i ++) {                                   // ursprüngliche Datenfeld-Ordnung wieder herstellen: "mmttjjjj Name" -> "jjjjmmtt Name"
    if (birthdays[i] != "Z") {                                        // wenn Eintrag keinen Dummy-String enthält
      bdaytemp = birthdays[i].substring(4, 8) + birthdays[i].substring(0, 4) + birthdays[i].substring(8); // String umbauen und zwischenspeichern
      birthdays[i] = bdaytemp;                                        // geänderten Eintrag speichern
    }
    else birthdays[i] = "";                                           // wenn Dummy-Eintrag -> String löschen
  }
  for (bdaycount = 0; bdaycount < MAXBDAYS; bdaycount ++) {           // Anzahl der Einträge ermitteln
    if (birthdays[bdaycount] == "") break;                            // wenn leerer String -> Ende
  }
}

// Callback-Function bei Zeit-Synchronisierung über ntp
void time_is_set() {
  if (wifistat == 2) {                                                // wenn WLAN verbunden
    Serial.println("Uhr wurde synchronisiert");
    syncstat = 2;                                                     // Status auf synchronisiert setzen
    synctout = SYNCTOUT;                                              // Timeout-Zähler setzen
  }
}

// MQTT-CallBack-Funktion für den Nachrichtenempfang
void onMqttMessage(const espMqttClientTypes::MessageProperties& properties, const char* topic, const uint8_t* payload, size_t len, size_t index, size_t total) {
  uint8_t i;                                                          // Zählervariable
  uint j, maxchars;                                                   // Zählervariable und maximale Zeichenanzahl
  bool found = false;                                                 // Merker wird gesetzt, wenn Topic gefunden (weitere Suchen werden dann nicht durchgeführt)

  if (!found) {                                                       // wenn Topic noch nicht gefunden
    maxchars = len;                                                   // Nachrichtenlänge kopieren
    if (maxchars > JSONBUFF - 1) maxchars = JSONBUFF - 1;             // maximale Zeichenanzahl begrenzen
    if (sensorlist_p[8]) {                                            // wenn MQTT-Topic vorhanden
      if (sensorlist[8] == topic) {                                   // wenn Topic übereinstimmt
        for (j = 0; j < maxchars; j ++) {                             // alle Zeichen im Payload
          weatherjson[j] = payload[j];                                // in Wetterdaten kopieren
        }
        weatherjson[j] = 0;                                           // String-Ende setzen
        weathertime = millis();                                       // Zeitstempel speichern
        weatherflag = true;                                           // neue Wetterdaten zum Verarbeiten empfangen
        found = true;                                                 // Topic wurde gefunden
      }
    }
  }

  if (!found) {                                                       // wenn Topic noch nicht gefunden
    maxchars = len;                                                   // Nachrichtenlänge kopieren
    if (maxchars > JSONBUFF - 1) maxchars = JSONBUFF - 1;             // maximale Zeichenanzahl begrenzen
    if (sensorlist_p[9]) {                                            // wenn MQTT-Topic vorhanden
      if (sensorlist[9] == topic) {                                   // wenn Topic übereinstimmt
        for (j = 0; j < maxchars; j ++) {                             // alle Zeichen im Payload
          fueljson[j] = payload[j];                                   // in Kraftstoffdaten kopieren
        }
        fueljson[j] = 0;                                              // String-Ende setzen
        fueltime = millis();                                          // Zeitstempel speichern
        fuelflag = true;                                              // neue Kraftstoffdaten zum Verarbeiten empfangen
        found = true;                                                 // Topic wurde gefunden
      }
    }
  }

  if (!found) {                                                       // wenn Topic noch nicht gefunden
    maxchars = len;                                                   // Nachrichtenlänge kopieren
    if (maxchars > TBUFFSIZE - 1) maxchars = TBUFFSIZE - 1;           // maximale Zeichenanzahl begrenzen
    if (sensorlist_p[10]) {                                           // wenn MQTT-Topic vorhanden
      if (sensorlist[10] == topic) {                                  // wenn Topic übereinstimmt
        message = "";                                                 // Textnachricht löschen
        for (j = 0; j < maxchars; j ++) {                             // alle Zeichen im Payload
          message += char(payload[j]);                                // an Textnachricht anfügen
        }
        messageflag = true;                                           // Textnachricht-Flag setzen
        found = true;                                                 // Topic wurde gefunden
      }
    }
  }

  if (!found) {                                                       // wenn Topic noch nicht gefunden
    maxchars = len;                                                   // Nachrichtenlänge kopieren
    if (maxchars > SENCHARS - 1) maxchars = SENCHARS - 1;             // maximale Zeichenanzahl begrenzen
    for (i = 0; i < 8; i ++) {                                        // 8 MQTT-Topics der Sensorliste prüfen
      if (sensorlist_p[i]) {                                          // wenn MQTT-Topic vorhanden
        if (sensorlist[i] == topic) {                                 // wenn Topic mit Nachricht übereinstimmt
          for (j = 0; j < maxchars; j ++) {                           // alle Zeichen im Payload
            sensorvals[i][j] = payload[j];                            // in Sensorwertefeld kopieren
          }
          sensorvals[i][j] = 0;                                       // String-Ende setzen
          sensortime[i] = millis();                                   // Zeitstempel speichern
          found = true;                                               // Topic wurde gefunden
          break;                                                      // Schleife abbrechen
        }
      }
    }
  }
}
