// Matrixuhr-Mini, Scott-Falk Hühn, "tables.h"
// Zeichensätze, Tabellen und Texte

// Großziffern für Zeitanzeige ohne Sekunden, feste Breite 6 Pixel
const uint8_t digit_array[] PROGMEM = {
  B01111110, B11111111, B10000001, B10000001, B11111111, B01111110,   // Ziffer '0'
  B00000000, B00000100, B00000110, B11111111, B11111111, B00000000,   // Ziffer '1'
  B11000010, B11100011, B10110001, B10011001, B10001111, B10000110,   // Ziffer '2'
  B01000010, B11000011, B10001001, B10001001, B11111111, B01110110,   // Ziffer '3'
  B00110000, B00111000, B00101100, B00100110, B11111111, B11111111,   // Ziffer '4'
  B01001111, B11001111, B10001001, B10001001, B11111001, B01110001,   // Ziffer '5'
  B01111100, B11111110, B10001011, B10001001, B11111000, B01110000,   // Ziffer '6'
  B00000001, B00000001, B11110001, B11111001, B00001111, B00000111,   // Ziffer '7'
  B01110110, B11111111, B10001001, B10001001, B11111111, B01110110,   // Ziffer '8'
  B00001110, B00011111, B10010001, B11010001, B01111111, B00111110,   // Ziffer '9'
};

// Großziffern für Zeitanzeige mit Sekunden, feste Breite 4 Pixel
const uint8_t digit_array2[] PROGMEM = {
  B01111110, B10000001, B10000001, B01111110,                         // Ziffer '0'
  B00000100, B00000010, B11111111, B00000000,                         // Ziffer '1'
  B11100010, B10010001, B10001001, B10000110,                         // Ziffer '2'
  B01000010, B10000001, B10001001, B01110110,                         // Ziffer '3'
  B00011000, B00010100, B00010010, B11111111,                         // Ziffer '4'
  B01001111, B10001001, B10001001, B01110001,                         // Ziffer '5'
  B01111100, B10001010, B10001001, B01110000,                         // Ziffer '6'
  B00000001, B11110001, B00001001, B00000111,                         // Ziffer '7'
  B01110110, B10001001, B10001001, B01110110,                         // Ziffer '8'
  B00001110, B10010001, B01010001, B00111110,                         // Ziffer '9'
};

// Zeichensatz für Laufschrift, variable Breite zwischen 1 und 5 Pixel
const uint8_t font_array[] PROGMEM = {
  3, B00000000, B00000000, B00000000, B00000000, B00000000,           // 0x20  32  ' '
  1, B01011111, B00000000, B00000000, B00000000, B00000000,           // 0x21  33  '!'
  3, B00000011, B00000000, B00000011, B00000000, B00000000,           // 0x22  34  '"'
  5, B00101000, B01111100, B00101000, B01111100, B00101000,           // 0x23  35  '#'
  5, B00000100, B00101010, B01111111, B00101010, B00010000,           // 0x24  36  '$'
  5, B01100011, B00010011, B00001000, B01100100, B01100011,           // 0x25  37  '%'
  5, B00110110, B01001001, B01010110, B00100000, B01010000,           // 0x26  38  '&'
  1, B00000011, B00000000, B00000000, B00000000, B00000000,           // 0x27  39  '''
  2, B00111110, B01000001, B00000000, B00000000, B00000000,           // 0x28  40  '('
  2, B01000001, B00111110, B00000000, B00000000, B00000000,           // 0x29  41  ')'
  5, B00101000, B00010000, B01111100, B00010000, B00101000,           // 0x2a  42  '*'
  5, B00010000, B00010000, B01111100, B00010000, B00010000,           // 0x2b  43  '+'
  2, B10000000, B01100000, B00000000, B00000000, B00000000,           // 0x2c  44  ','
  3, B00010000, B00010000, B00010000, B00000000, B00000000,           // 0x2d  45  '-'
  1, B01000000, B00000000, B00000000, B00000000, B00000000,           // 0x2e  46  '.'
  3, B01100000, B00011100, B00000011, B00000000, B00000000,           // 0x2f  47  '/'

  4, B00111110, B01000001, B01000001, B00111110, B00000000,           // 0x30  48  '0'
  3, B00000100, B00000010, B01111111, B00000000, B00000000,           // 0x31  49  '1'
  4, B01100010, B01010001, B01001001, B01000110, B00000000,           // 0x32  50  '2'
  4, B00100010, B01000001, B01001001, B00110110, B00000000,           // 0x33  51  '3'
  4, B00011000, B00010100, B00010010, B01111111, B00000000,           // 0x34  52  '4'
  4, B00100111, B01000101, B01000101, B00111001, B00000000,           // 0x35  53  '5'
  4, B00111100, B01001010, B01001001, B00110000, B00000000,           // 0x36  54  '6'
  4, B00000001, B01110001, B00001001, B00000111, B00000000,           // 0x37  55  '7'
  4, B00110110, B01001001, B01001001, B00110110, B00000000,           // 0x38  56  '8'
  4, B00000110, B01001001, B00101001, B00011110, B00000000,           // 0x39  57  '9'
  1, B01000100, B00000000, B00000000, B00000000, B00000000,           // 0x3a  58  ':'
  2, B10000000, B01101000, B00000000, B00000000, B00000000,           // 0x3b  59  ';'
  3, B00010000, B00101000, B01000100, B00000000, B00000000,           // 0x3c  60  '<'
  4, B00101000, B00101000, B00101000, B00101000, B00000000,           // 0x3d  61  '='
  3, B01000100, B00101000, B00010000, B00000000, B00000000,           // 0x3e  62  '>'
  4, B00000010, B01010001, B00001001, B00000110, B00000000,           // 0x3f  63  '?'

  5, B00111110, B01001001, B01010101, B01011101, B00001110,           // 0x40  64  '@'
  4, B01111110, B00010001, B00010001, B01111110, B00000000,           // 0x41  65  'A'
  4, B01111111, B01001001, B01001001, B00110110, B00000000,           // 0x42  66  'B'
  4, B00111110, B01000001, B01000001, B00100010, B00000000,           // 0x43  67  'C'
  4, B01111111, B01000001, B01000001, B00111110, B00000000,           // 0x44  68  'D'
  4, B01111111, B01001001, B01001001, B01000001, B00000000,           // 0x45  69  'E'
  4, B01111111, B00001001, B00001001, B00000001, B00000000,           // 0x46  70  'F'
  4, B00111110, B01000001, B01001001, B00111010, B00000000,           // 0x47  71  'G'
  4, B01111111, B00001000, B00001000, B01111111, B00000000,           // 0x48  72  'H'
  1, B01111111, B00000000, B00000000, B00000000, B00000000,           // 0x49  73  'I'
  4, B00110000, B01000001, B01000001, B00111111, B00000000,           // 0x4a  74  'J'
  4, B01111111, B00001000, B00010100, B01100011, B00000000,           // 0x4b  75  'K'
  4, B01111111, B01000000, B01000000, B01000000, B00000000,           // 0x4c  76  'L'
  5, B01111111, B00000010, B00001100, B00000010, B01111111,           // 0x4d  77  'M'
  5, B01111111, B00000100, B00001000, B00010000, B01111111,           // 0x4e  78  'N'
  4, B00111110, B01000001, B01000001, B00111110, B00000000,           // 0x4f  79  'O'

  4, B01111111, B00001001, B00001001, B00000110, B00000000,           // 0x50  80  'P'
  4, B00111110, B01000001, B01000001, B10111110, B00000000,           // 0x51  81  'Q'
  4, B01111111, B00001001, B00001001, B01110110, B00000000,           // 0x52  82  'R'
  4, B00100110, B01001001, B01001001, B00110010, B00000000,           // 0x53  83  'S'
  5, B00000001, B00000001, B01111111, B00000001, B00000001,           // 0x54  84  'T'
  4, B00111111, B01000000, B01000000, B00111111, B00000000,           // 0x55  85  'U'
  5, B00000111, B00011000, B01100000, B00011000, B00000111,           // 0x56  86  'V'
  5, B00111111, B01000000, B00111000, B01000000, B00111111,           // 0x57  87  'W'
  5, B01100011, B00010100, B00001000, B00010100, B01100011,           // 0x58  88  'X'
  5, B00000111, B00001000, B01110000, B00001000, B00000111,           // 0x59  89  'Y'
  5, B01100001, B01010001, B01001001, B01000101, B01000011,           // 0x5a  90  'Z'
  2, B01111111, B01000001, B00000000, B00000000, B00000000,           // 0x5b  91  '['
  3, B00000011, B00011100, B01100000, B00000000, B00000000,           // 0x5c  92  '\'
  2, B01000001, B01111111, B00000000, B00000000, B00000000,           // 0x5d  93  ']'
  3, B00000010, B00000001, B00000010, B00000000, B00000000,           // 0x5e  94  '^'
  4, B01000000, B01000000, B01000000, B01000000, B00000000,           // 0x5f  95  '_'

  2, B00000001, B00000010, B00000000, B00000000, B00000000,           // 0x60  96  '`'
  4, B00100000, B01010100, B01010100, B01111000, B00000000,           // 0x61  97  'a'
  4, B01111111, B01000100, B01000100, B00111000, B00000000,           // 0x62  98  'b'
  3, B00111000, B01000100, B01000100, B00000000, B00000000,           // 0x63  99  'c'
  4, B00111000, B01000100, B01000100, B01111111, B00000000,           // 0x64 100  'd'
  4, B00111000, B01010100, B01010100, B00011000, B00000000,           // 0x65 101  'e'
  3, B00001000, B01111110, B00001001, B00000000, B00000000,           // 0x66 102  'f'
  4, B00011000, B10100100, B10100100, B01111000, B00000000,           // 0x67 103  'g'
  4, B01111111, B00000100, B00000100, B01111000, B00000000,           // 0x68 104  'h'
  1, B01111101, B00000000, B00000000, B00000000, B00000000,           // 0x69 105  'i'
  2, B10000000, B01111101, B00000000, B00000000, B00000000,           // 0x6a 106  'j'
  4, B01111111, B00010000, B00101000, B01000100, B00000000,           // 0x6b 107  'k'
  2, B00111111, B01000000, B00000000, B00000000, B00000000,           // 0x6c 108  'l'
  5, B01111100, B00000100, B01111100, B00000100, B01111000,           // 0x6d 109  'm'
  4, B01111100, B00000100, B00000100, B01111000, B00000000,           // 0x6e 110  'n'
  4, B00111000, B01000100, B01000100, B00111000, B00000000,           // 0x6f 111  'o'

  4, B11111100, B00100100, B00100100, B00011000, B00000000,           // 0x70 112  'p'
  4, B00011000, B00100100, B00100100, B11111100, B00000000,           // 0x71 113  'q'
  4, B01111100, B00001000, B00000100, B00001000, B00000000,           // 0x72 114  'r'
  4, B01001000, B01010100, B01010100, B00100000, B00000000,           // 0x73 115  's'
  3, B00000100, B00111111, B01000100, B00000000, B00000000,           // 0x74 116  't'
  4, B00111100, B01000000, B01000000, B01111100, B00000000,           // 0x75 117  'u'
  5, B00011100, B00100000, B01000000, B00100000, B00011100,           // 0x76 118  'v'
  5, B00111100, B01000000, B00111100, B01000000, B00111100,           // 0x77 119  'w'
  5, B01000100, B00101000, B00010000, B00101000, B01000100,           // 0x78 120  'x'
  4, B00011100, B10100000, B10100000, B01111100, B00000000,           // 0x79 121  'y'
  4, B01100100, B01010100, B01001100, B01000100, B00000000,           // 0x7a 122  'z'
  3, B00001000, B00110110, B01000001, B00000000, B00000000,           // 0x7b 123  '{'
  1, B01111111, B00000000, B00000000, B00000000, B00000000,           // 0x7c 124  '|'
  3, B01000001, B00110110, B00001000, B00000000, B00000000,           // 0x7d 125  '}'
  4, B00001000, B00000100, B00001000, B00000100, B00000000,           // 0x7e 126  '~'
  1, B00000000, B00000000, B00000000, B00000000, B00000000,           // 0x7f 127  nicht genutzt

  4, B01111101, B00010010, B00010010, B01111101, B00000000,           // 0x80 128  'Ä'
  4, B00111101, B01000010, B01000010, B00111101, B00000000,           // 0x81 129  'Ö'
  4, B00111101, B01000000, B01000000, B00111101, B00000000,           // 0x82 130  'Ü'
  4, B00100001, B01010100, B01010100, B01111001, B00000000,           // 0x83 131  'ä'
  4, B00111001, B01000100, B01000100, B00111001, B00000000,           // 0x84 132  'ö'
  4, B00111101, B01000000, B01000000, B01111101, B00000000,           // 0x85 133  'ü'
  4, B01111111, B00000001, B01001001, B00110110, B00000000,           // 0x86 134  'ß'
  4, B00111000, B01010100, B01010101, B00011000, B00000000,           // 0x87 135  'é'
  1, B00000001, B00000000, B00000000, B00000000, B00000000,           // 0x88 136  '°'
  5, B00010100, B00111110, B01010101, B01000001, B00100010,           // 0x89 137  '€'
};

// Zeichensatz für Symbole, variable Breite zwischen 1 und 16 Pixel
const uint8_t symbol_array[] PROGMEM = {
   3, B00001000, B00011100, B00001000, B00000000, B00000000, B00000000, B00000000, B00000000,
      B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, // $0 Wind neutral
   5, B00000100, B00000010, B01111111, B00000010, B00000100, B00000000, B00000000, B00000000,
      B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, // $1 Wind aus Süd
   7, B01000000, B00100000, B00010000, B00001001, B00000101, B00000011, B00001111, B00000000,
      B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, // $2 Wind aus Südwest
   7, B00001000, B00001000, B00001000, B00001000, B00101010, B00011100, B00001000, B00000000,
      B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, // $3 Wind aus West
   7, B00000001, B00000010, B00000100, B01001000, B01010000, B01100000, B01111000, B00000000,
      B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, // $4 Wind aus Nordwest
   5, B00010000, B00100000, B01111111, B00100000, B00010000, B00000000, B00000000, B00000000,
      B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, // $5 Wind aus Nord
   7, B01111000, B01100000, B01010000, B01001000, B00000100, B00000010, B00000001, B00000000,
      B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, // $6 Wind aus Nordost
   7, B00001000, B00011100, B00101010, B00001000, B00001000, B00001000, B00001000, B00000000,
      B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, // $7 Wind aus Ost
   7, B00001111, B00000011, B00000101, B00001001, B00010000, B00100000, B01000000, B00000000,
      B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, // $8 Wind aus Südost
   8, B00100100, B00101000, B10011011, B01111100, B00111110, B11011001, B00010100, B00100100,
      B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, // $A klarer Himmel (Tag-Symbol)
   7, B00011100, B00111110, B01111111, B01111111, B01111111, B00111110, B00011100, B00000000,
      B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, // $B klarer Himmel (Nacht-Symbol)
  16, B00100100, B00101000, B10011011, B01111100, B00111110, B11011001, B00010100, B00100100,
      B00000000, B00000000, B00000010, B00000111, B01000111, B11100010, B11100000, B01000000, // $C Ein paar Wolken (Tag-Symbol)
  15, B00011100, B00111110, B01111111, B01111111, B01111111, B00111110, B00011100, B00000000,
      B00000000, B00000010, B00000111, B00100111, B01110010, B01110000, B00100000, B00000000, // $D Ein paar Wolken (Nacht-Symbol)
  16, B00100100, B00101000, B10011011, B01111100, B00001110, B01100101, B11110000, B11111000,
      B01111000, B11111000, B11110010, B01100111, B01001111, B00001111, B00000111, B00000010, // $E Mäßig bewölkt (Tag-Symbol)
  16, B00011100, B00111110, B01111111, B01111111, B00001111, B01100110, B11110100, B11110000,
      B01111000, B11111000, B11110010, B01100111, B01001111, B00001111, B00000111, B00000010, // $F Mäßig bewölkt (Nacht-Symbol)
  16, B00000100, B00001110, B00001110, B00001111, B00001111, B01100111, B11110010, B11111000,
      B11111000, B11111000, B11110010, B01100111, B01001111, B00001111, B00000111, B00000010, // $G Überwiegend bewölkt (Tag-Symbol)
  16, B00000100, B00001110, B00001110, B00001111, B00001111, B01100111, B11110010, B11111000,
      B11111000, B11111000, B11110010, B01100111, B01001111, B00001111, B00000111, B00000010, // $H Überwiegend bewölkt (Nacht-Symbol)
  15, B00000100, B00001110, B11001110, B01101111, B00000111, B11000110, B01100010, B00000000,
      B11000010, B01100110, B00001111, B11001111, B01101111, B00000111, B00000010, B00000000, // $I Regenschauer (Tag-Symbol)
  15, B00000100, B00001110, B11001110, B01101111, B00000111, B11000110, B01100010, B00000000,
      B11000010, B01100110, B00001111, B11001111, B01101111, B00000111, B00000010, B00000000, // $J Regenschauer (Nacht-Symbol)
  16, B00100100, B00101000, B10011011, B01111100, B00111110, B11011001, B00010100, B00000100,
      B11000000, B01100010, B00000110, B11001111, B01100111, B00001111, B11000111, B01100010, // $K Regen (Tag-Symbol)
  16, B00011100, B00111110, B01111111, B01111111, B01111111, B00111110, B00011100, B00000000,
      B11000000, B01100010, B00000110, B11001111, B01100111, B00001111, B11000111, B01100010, // $L Regen (Nacht-Symbol)
  14, B10011000, B01010110, B00110010, B00000000, B00000100, B11000110, B01101111, B00001111,
      B11001110, B01100111, B00001111, B11001111, B01100111, B00000010, B00000000, B00000000, // $M Gewitter (Tag-Symbol)
  14, B10011000, B01010110, B00110010, B00000000, B00000100, B11000110, B01101111, B00001111,
      B11001110, B01100111, B00001111, B11001111, B01100111, B00000010, B00000000, B00000000, // $N Gewitter (Nacht-Symbol)
  16, B00000100, B10101110, B01001110, B10101111, B00000111, B01010111, B00100010, B01010000,
      B00000010, B10100110, B01001111, B10101111, B00000111, B01010111, B00100111, B01010010, // $O Schnee (Tag-Symbol)
  16, B00000100, B10101110, B01001110, B10101111, B00000111, B01010111, B00100010, B01010000,
      B00000010, B10100110, B01001111, B10101111, B00000111, B01010111, B00100111, B01010010, // $P Schnee (Nacht-Symbol)
  16, B01001001, B01001001, B10010010, B10010010, B10010010, B10010010, B01001001, B01001001,
      B01001001, B01001001, B10010010, B10010010, B10010010, B10010010, B01001001, B01001001, // $Q Nebel (Tag-Symbol)
  16, B01001001, B01001001, B10010010, B10010010, B10010010, B10010010, B01001001, B01001001,
      B01001001, B01001001, B10010010, B10010010, B10010010, B10010010, B01001001, B01001001, // $R Nebel (Nacht-Symbol)
  16, B00001000, B00001010, B01000010, B01000000, B00000000, B00000100, B10000100, B10000000,
      B00010001, B00010001, B00000000, B01000000, B01000010, B00000010, B00010000, B00010000, // $S Fehler
   8, B00100100, B00101000, B10011011, B01111100, B00111110, B11011001, B00010100, B00100100,
      B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, // $T Sonnensymbol
  11, B11000000, B10100001, B10100101, B10100011, B10101111, B11100111, B10101111, B10100011,
      B10100101, B10100001, B11000000, B00000000, B00000000, B00000000, B00000000, B00000000, // $U Solar-Symbol
   4, B11111110, B11110011, B11100011, B11111110, B00000000, B00000000, B00000000, B00000000,
      B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, // $V Batterie-Symbol
   8, B10000000, B11111111, B11110001, B11110001, B11111111, B10010000, B00100111, B00011110,
      B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, // $W Tankstellen-Symbol
  16, B00000110, B00001111, B00011111, B00001111, B00000111, B00001110, B01101111, B01100111,
      B11110011, B11111010, B11111000, B01111000, B11111100, B11111100, B01111000, B00110000, // $X Wolken-Symbol
  13, B01001000, B01001000, B01001000, B01001000, B01001010, B01001001, B01001001, B01000110,
      B01000000, B01010000, B01001000, B01001000, B00110000, B00000000, B00000000, B00000000, // $Y Wind-Symbol
  14, B00011000, B00111100, B00110110, B00011111, B00000000, B01100000, B11110000, B11011000,
      B01111100, B00000000, B00110000, B01111000, B01101100, B00111110, B00000000, B00000000, // $Z Regen-Symbol
};

// Strings
const char string00[] PROGMEM = VERSION_NUMB;   // Versionsnummer für Webseite
const char string01[] PROGMEM = VERSION_DATE;   // Versionsdatum für Webseite
const char string02[] PROGMEM = "Sonntag";
const char string03[] PROGMEM = "Montag";
const char string04[] PROGMEM = "Dienstag";
const char string05[] PROGMEM = "Mittwoch";
const char string06[] PROGMEM = "Donnerstag";
const char string07[] PROGMEM = "Freitag";
const char string08[] PROGMEM = "Samstag";
const char string09[] PROGMEM = "kein Datum";
const char string10[] PROGMEM = "kein Tag";
const char string11[] PROGMEM = "kein Geburtstag";
const char string12[] PROGMEM = "Update";
const char string13[] PROGMEM = "ok";
const char string14[] PROGMEM = "Fehler";
const char string15[] PROGMEM = "Reboot";

const char* const stringsd[] PROGMEM = {
  string00, string01, string02, string03, string04, string05, string06, string07, string08, string09, string10, string11, string12, string13, string14, string15
};

// UTF-8 Tabelle für 2-Byte-Zeichen: ÄÖÜäöüéß°
const uint8_t utf8tab[] PROGMEM = {
  0xc3, 0x84, 128,        // Code C3 84 -> Ä
  0xc3, 0x96, 129,        // Code C3 96 -> Ö
  0xc3, 0x9c, 130,        // Code C3 9C -> Ü
  0xc3, 0xa4, 131,        // Code C3 A4 -> ä
  0xc3, 0xb6, 132,        // Code C3 B6 -> ö
  0xc3, 0xbc, 133,        // Code C3 BC -> ü
  0xc3, 0x9f, 134,        // Code C3 9F -> ß
  0xc3, 0xa9, 135,        // Code C3 A9 -> é
  0xc2, 0xb0, 136         // Code C2 B0 -> Gradzeichen
};

// UTF-8 Tabelle für 3-Byte-Zeichen: €
const uint8_t utf8tab3[] PROGMEM = {
  0xe2, 0x82, 0xac, 137   // Code E2 82 AC -> €
};

// favicon.png, 16x16 Pixel
const uint8_t favicon[] = {
  0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A, 0x00, 0x00, 0x00, 0x0D, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x08, 0x06, 0x00, 0x00, 0x00, 0x1F, 0xF3, 0xFF, 0x61,
  0x00, 0x00, 0x00, 0x2B, 0x74, 0x45, 0x58, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x54, 0x69, 0x6D, 0x65, 0x00, 0x53, 0x61, 0x20, 0x32, 0x32, 0x20, 0x41, 0x70, 0x72, 0x20, 0x32,
  0x30, 0x32, 0x33, 0x20, 0x32, 0x32, 0x3A, 0x31, 0x37, 0x3A, 0x33, 0x30, 0x20, 0x2B, 0x30, 0x31, 0x30, 0x30, 0x7C, 0xCF, 0x4E, 0x65, 0x00, 0x00, 0x00, 0x07, 0x74, 0x49, 0x4D, 0x45, 0x07, 0xE9, 0x02,
  0x14, 0x14, 0x21, 0x04, 0xC8, 0xF9, 0xA9, 0x14, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0F, 0x60, 0x00, 0x00, 0x0F, 0x60, 0x01, 0x7A, 0x78, 0x45, 0x8D, 0x00, 0x00, 0x00, 0x04,
  0x67, 0x41, 0x4D, 0x41, 0x00, 0x00, 0xB1, 0x8F, 0x0B, 0xFC, 0x61, 0x05, 0x00, 0x00, 0x00, 0x7B, 0x49, 0x44, 0x41, 0x54, 0x78, 0xDA, 0xAD, 0x51, 0x01, 0x0E, 0x80, 0x20, 0x08, 0x84, 0xE6, 0xBF, 0xFC,
  0xBA, 0xBE, 0x8C, 0xA4, 0xA5, 0x9D, 0xAC, 0xA8, 0x26, 0xB7, 0x39, 0x77, 0x87, 0xC3, 0x3B, 0x60, 0x2A, 0x45, 0x08, 0x20, 0x39, 0xB3, 0xDE, 0x5C, 0xEB, 0x27, 0x3D, 0x61, 0xD1, 0xE2, 0x4D, 0xD7, 0x66,
  0x1B, 0x2D, 0x22, 0xA1, 0x2D, 0xFB, 0x23, 0xDA, 0xC5, 0xDA, 0x1C, 0xA3, 0xCD, 0xA0, 0x81, 0xBC, 0x83, 0x6F, 0xEC, 0xFB, 0xD8, 0x08, 0xDE, 0xB4, 0x9F, 0xC0, 0x87, 0xAD, 0x05, 0x44, 0x45, 0x60, 0x88,
  0x20, 0xFC, 0x87, 0x9F, 0x93, 0x25, 0xC1, 0xFB, 0x9A, 0xB8, 0xAF, 0xC7, 0x6D, 0xC1, 0xC6, 0x98, 0x2C, 0x1A, 0x4D, 0x23, 0x20, 0x1F, 0x0E, 0x7A, 0x01, 0x39, 0x6A, 0x77, 0xF5, 0x90, 0x2D, 0x8C, 0x06,
  0xD6, 0xB6, 0x72, 0x2F, 0x56, 0xE7, 0x3B, 0xFE, 0x11, 0xA8, 0x99, 0x3F, 0xA5, 0xCC, 0x7A, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4E, 0x44, 0xAE, 0x42, 0x60, 0x82
};

// Wetter-Iconliste
const char weathericons[] = {
  '0', '1',               // 01d/01n - Klarer Himmel
  '0', '2',               // 02d/02n - Ein paar Wolken
  '0', '3',               // 03d/03n - Mäßig bewölkt
  '0', '4',               // 04d/04n - Überwiegend bewölkt
  '0', '9',               // 09d/09n - Regenschauer
  '1', '0',               // 10d/10n - Regen
  '1', '1',               // 11d/11n - Gewitter
  '1', '3',               // 13d/13n - Schnee
  '5', '0'                // 50d/50n - Nebel
};

// Wetterlage-Texte deutsch, Umlaute müssen folgendermaßen geschrieben werden:
// Ä = \200, Ö = \201, Ü = \202, ä = \203, ö = \204, ü = \205, ß = \206
const char wcstrd00[] PROGMEM = "200 Gewitter mit leichtem Regen";
const char wcstrd01[] PROGMEM = "201 Gewitter mit Regen";
const char wcstrd02[] PROGMEM = "202 Gewitter mit starkem Regen";
const char wcstrd03[] PROGMEM = "210 Leichtes Gewitter";
const char wcstrd04[] PROGMEM = "211 Gewitter";
const char wcstrd05[] PROGMEM = "212 Schweres Gewitter";
const char wcstrd06[] PROGMEM = "221 Einige Gewitter";
const char wcstrd07[] PROGMEM = "230 Gewitter mit leichtem Nieselregen";
const char wcstrd08[] PROGMEM = "231 Gewitter mit Nieselregen";
const char wcstrd09[] PROGMEM = "232 Gewitter mit starkem Nieselregen";
const char wcstrd10[] PROGMEM = "300 Leichtes Nieseln";
const char wcstrd11[] PROGMEM = "301 Nieseln";
const char wcstrd12[] PROGMEM = "302 Starkes Nieseln";
const char wcstrd13[] PROGMEM = "310 Leichter Nieselregen";
const char wcstrd14[] PROGMEM = "311 Nieselregen";
const char wcstrd15[] PROGMEM = "312 Starker Nieselregen";
const char wcstrd16[] PROGMEM = "313 Regen und Niesel";
const char wcstrd17[] PROGMEM = "314 Starker Regen und Niesel";
const char wcstrd18[] PROGMEM = "321 Spr\205hregen";
const char wcstrd19[] PROGMEM = "500 Leichter Regen";
const char wcstrd20[] PROGMEM = "501 M\203\206iger Regen";
const char wcstrd21[] PROGMEM = "502 Starker Regen";
const char wcstrd22[] PROGMEM = "503 Sehr starker Regen";
const char wcstrd23[] PROGMEM = "504 Extremer Regen";
const char wcstrd24[] PROGMEM = "511 Gefrierender Regen";
const char wcstrd25[] PROGMEM = "520 Leichter Regen- schauer";
const char wcstrd26[] PROGMEM = "521 Regen- schauer";
const char wcstrd27[] PROGMEM = "522 Starker Regen- schauer";
const char wcstrd28[] PROGMEM = "531 Einige Regen- schauer";
const char wcstrd29[] PROGMEM = "600 Leichter Schneefall";
const char wcstrd30[] PROGMEM = "601 Schneefall";
const char wcstrd31[] PROGMEM = "602 Starker Schneefall";
const char wcstrd32[] PROGMEM = "611 Schneeregen";
const char wcstrd33[] PROGMEM = "612 Schneeregen Schauer";
const char wcstrd34[] PROGMEM = "613 Starker Schneeregen";
const char wcstrd35[] PROGMEM = "615 Leichter Regen und Schneefall";
const char wcstrd36[] PROGMEM = "616 Regen und Schneefall";
const char wcstrd37[] PROGMEM = "620 Leichter Schnee- schauer";
const char wcstrd38[] PROGMEM = "621 Schnee- Schauer";
const char wcstrd39[] PROGMEM = "622 Starker Schnee- schauer";
const char wcstrd40[] PROGMEM = "701 Dunst";
const char wcstrd41[] PROGMEM = "711 Rauch";
const char wcstrd42[] PROGMEM = "721 Tr\205b";
const char wcstrd43[] PROGMEM = "731 Sand und Staubwirbel";
const char wcstrd44[] PROGMEM = "741 Nebel";
const char wcstrd45[] PROGMEM = "751 Sand";
const char wcstrd46[] PROGMEM = "761 Staub";
const char wcstrd47[] PROGMEM = "762 Vulkanasche";
const char wcstrd48[] PROGMEM = "771 B\204en";
const char wcstrd49[] PROGMEM = "781 Orkan";
const char wcstrd50[] PROGMEM = "800 Klarer Himmel";
const char wcstrd51[] PROGMEM = "801 Ein paar Wolken";
const char wcstrd52[] PROGMEM = "802 M\203\206ig bew\204lkt";
const char wcstrd53[] PROGMEM = "803 \202berwiegend bew\204lkt";
const char wcstrd54[] PROGMEM = "804 Bedeckt";
const char wcstrd55[] PROGMEM = "999 keine Wetterlage";

// Wetterlagenliste
const char * const PROGMEM wcstringsd[] = {
  wcstrd00, wcstrd01, wcstrd02, wcstrd03, wcstrd04, wcstrd05, wcstrd06, wcstrd07, wcstrd08, wcstrd09,
  wcstrd10, wcstrd11, wcstrd12, wcstrd13, wcstrd14, wcstrd15, wcstrd16, wcstrd17, wcstrd18, wcstrd19,
  wcstrd20, wcstrd21, wcstrd22, wcstrd23, wcstrd24, wcstrd25, wcstrd26, wcstrd27, wcstrd28, wcstrd29,
  wcstrd30, wcstrd31, wcstrd32, wcstrd33, wcstrd34, wcstrd35, wcstrd36, wcstrd37, wcstrd38, wcstrd39,
  wcstrd40, wcstrd41, wcstrd42, wcstrd43, wcstrd44, wcstrd45, wcstrd46, wcstrd47, wcstrd48, wcstrd49,
  wcstrd50, wcstrd51, wcstrd52, wcstrd53, wcstrd54, wcstrd55
};
