// Matrixuhr-ESP32, Scott-Falk Hühn, "http.h"
// Webserver-Daten und -Funktionen

// HTML-Header und CSS-Definitionen, wird von allen Seiten verwendet
const char header[] PROGMEM = R"rawliteral(<html lang="de">
<head>
 <title>Matrixuhr-ESP32</title>
 <meta charset="utf-8" />
 <meta name="author" content="Scott Falk Hühn" />
 <meta name="date" content="%VDATE%" />
 <style>
  body {font-size:14px; color:black; font-family:Helvetica,Arial,sans-serif; text-decoration:none}
  div.menu {position:absolute; top:2px; left:2px; width:150px; margin-bottom:5px; background-color:#f8f8f8; border-style:solid; border-color:gray; border-radius:6px; border-width:1px; padding-left:4px; padding-right:4px; padding-bottom:6px; overflow-x:auto; overflow-y:auto}
  div.main {position:absolute; top:0px; left:165px; right:5px; overflow-x:auto; overflow-y:auto}
  a {color:black; text-decoration:none; margin-left:14px}
  a:hover {border:1px solid #000; padding:0px 4px}
  h1 {font-size:16px; background-color:#e8e8e8; text-align:center}
  hr {color:lightgray}
  th {font-weight:normal; color:navy; padding:2px 4px}
  td {padding:2px 4px}
  fieldset {border-radius:6px; border-width:1px; border-color:darkgray; display:inline-block}
  select {width:100%%}
  .hd {font-size:15px; color:maroon; margin-bottom:5px}
  .cg {color:green}
  .co {color:orange}
  .cr {color:red}
  .le {text-align:left}
  .cc {text-align:center}
  .ri {text-align:right}
  .cx {border-radius:6px; border-style:solid; border-width:1px}
  .bo {font-weight:bold}
  .mx {width:100%%}
  .rg {color:white; background-color:#0a0; padding:2px; border-radius:6px}
  .rr {color:white; background-color:red; padding:2px; border-radius:6px}
  .bt {width:100px}
  .pr {padding-right:12px}
  .ml {margin-left:0px}
  .stat a.stat, .bday a.bday, .sens a.sens, .data a.data, .alms a.alms, .cols a.cols, .disp a.disp, .soun a.soun, .hard a.hard, .wifi a.wifi, .netw a.netw, .mqtt a.mqtt, .time a.time, .http a.http, .test a.test, .file a.file, .fwup a.fwup {background:#333; color:white; padding:0px 4px}
 </style>
</head>)rawliteral";

// Linkes Seitenmenü, wird von allen Seiten verwendet
const char leftmenu[] PROGMEM = R"rawliteral(<h1>Matrixuhr-ESP32</h1>
 <div class="hd">Informationen</div>
 <a class="stat" href="/">Status</a>
 <hr>
 <div class="hd">Konfiguration</div>
 <a class="bday" href="/bday">Geburtstage</a><br>
 <a class="sens" href="/sens">Sensoren</a><br>
 <a class="data" href="/data">Datenausgabe</a><br>
 <a class="alms" href="/alms">Alarme</a><br>
 <a class="cols" href="/cols">Farben</a><br>
 <a class="disp" href="/disp">Anzeige</a><br>
 <a class="soun" href="/soun">Sound</a>
 <hr>
 <div class="hd">System-Einstellungen</div>
 <a class="hard" href="/hard">Hardware</a><br>
 <a class="wifi" href="/wifi">WLAN</a><br>
 <a class="netw" href="/netw">Netzwerk</a><br>
 <a class="mqtt" href="/mqtt">MQTT</a><br>
 <a class="time" href="/time">Zeit</a><br>
 <a class="http" href="/http">Sicherheit</a>
 <hr>
 <div class="hd">Wartung</div>
 <a class="test" href="/test">Test-Funktionen</a><br>
 <a class="file" href="/file">Datei-Manager</a><br>
 <a class="fwup" href="/fwup">Firmware-Update</a><br>
 <a class="boot" href="/boot">Neustart</a>)rawliteral";

// Statusanzeige grüner Haken
const char status_green[] PROGMEM = R"rawliteral(<span class="cg bo">&check;</span>)rawliteral";

// Statusanzeige oranger Haken
const char status_orange[] PROGMEM = R"rawliteral(<span class="co bo">&check;</span>)rawliteral";

// Statusanzeige rotes Kreuz
const char status_red[] PROGMEM = R"rawliteral(<span class="cr bo">&cross;</span>)rawliteral";

// Ergebnisanzeige grün ok
const char result_green[] PROGMEM = R"rawliteral(<span class="rg">&nbsp;OK&nbsp;</span>)rawliteral";

// Ergebnisanzeige rot Fehler
const char result_red[] PROGMEM = R"rawliteral(<span class="rr">&nbsp;Fehler&nbsp;</span>)rawliteral";

// Statusanzeige "aus"
const char status_aus[] PROGMEM = R"rawliteral(<span class="rg">&nbsp;Aus&nbsp;</span>)rawliteral";

// Statusanzeige "ein"
const char status_ein[] PROGMEM = R"rawliteral(<span class="rr">&nbsp;Ein&nbsp;</span>)rawliteral";

// Neustart-Hinweis
const char reboot_msg[] PROGMEM = R"rawliteral(<tr><td colspan="2" class="cr">Bitte Matrixuhr neu starten</td></tr>)rawliteral";

// Texte für Auswahl- und Checkboxen
const char selected[] PROGMEM = "selected";
const char checked[] PROGMEM = "checked";
const char disabled[] PROGMEM = "disabled";

// Seite Informationen, Status
const char stat_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="stat">
<div class="menu">%MENU%</div>
<div class="main">
 <form action="/" method="post">
  <fieldset>
   <legend>Status</legend>
   <table>
    <tr><th colspan="5">Übersicht</th></tr>
    <tr><td>Software-Version</td><td>%VERSION%</td><td></td><td>Chip-Modell</td><td>%CHIPMOD%</td></tr>
    <tr><td>Software-Datum</td><td>%VDATE%</td><td></td><td>Chip-Version</td><td>%CHIPVER%</td></tr>
    <tr><td>Systemlaufzeit</td><td>%UPTIME%</td><td></td><td>CPU-Frequenz</td><td>%CPUFREQ% MHz</td></tr>
    <tr><td>WLAN-SSID</td><td>%SSID%</td><td></td><td>Flash-Speicher</td><td>%FLSHSIZE% Byte</td></tr>
    <tr><td>WLAN-Signal</td><td>%RSSI% dB</td><td></td><td>RAM verwendet</td><td>%HEAPSIZE% Byte</td></tr>
    <tr><td>Dateisystem</td><td>%FILESYS%</td><td></td><td>RAM frei</td><td>%FREEHEAP% Byte</td></tr>
    <tr><td>Zeit-Status</td><td>%TIMESYNC%</td><td></td><td></td><td></td></tr>
    <tr><td>MQTT-Status</td><td>%MQTT%</td><td></td><td>Stumm-Modus</td><td>%MUTE%</td></tr>
    <tr><td colspan="5"><hr></td></tr>
   </table>
   <table class="mx">
    <tr><td><button type="submit" formaction="/stqu">Alarme quittieren</button> <button type="submit" formaction="/stmu">Stummschaltung</button></td><td class="ri"><button type="submit">Aktualisieren</button></td></tr>
    <tr><td colspan="2"><hr></td></tr>
   </table>
   <table class="mx">
    <tr><th>Textnachricht</th></tr>
    <tr><td class="pr"><input class="mx" type="text" maxlength="100" name="message" value="%MESSAGE%"></td></tr>
    <tr><td><hr></td></tr>
    <tr><td><button type="submit" formaction="/mesg">Nachricht anzeigen</button> %SAVE%</td></tr>
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite Konfiguration, Geburtstage
const char bday_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="bday">
<div class="menu">%MENU%</div>
<div class="main">
 <form action="/bday" method="post">
  <fieldset>
   <legend>Geburtstage</legend>
   <table>
    <tr class="cc"><td><input type="text" name="bday_deln" size="2" maxlength="3" value=""></td><td><button type="submit" formaction="/bdel" %DISAB%>Eintrag löschen</button></td><td class="le">%SAVE%</td><td class="ri"><button type="submit" formaction="/bdpg">Seite %BDAYPAGE%</button></td></tr>
    <tr><td colspan="4"><hr></td></tr>
    <tr class="cc"><th>Nummer</th><th>Geburtstag</th><th colspan="2" class="le">Name</th></tr>
    <tr class="cc"><td><button type="submit" %BDDISAB%> + </button></td><td><input type="date" name="bday_date"></td><td colspan="2"><input type="text" name="bday_name" size="25" maxlength="25"></td></tr>
%BDAYLIST%   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite Konfiguration, Sensoren
const char sens_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="sens">
<div class="menu">%MENU%</div>
<div class="main">
 <form action="/sens" method="post">
  <fieldset>
   <legend>Sensoren</legend>
   <table>
    <tr><th>Name</th><th>MQTT Topic für Sensoren</th><th>Dezimal</th><th>Wert</th></tr>
    <tr class="cc"><td>[A]</td><td><input type="text" size="40" maxlength="80" name="sena" value="%SENA%"></td><td><select name="seda"><option value="0" %SEDA0%>0</option><option value="1" %SEDA1%>1</option><option value="2" %SEDA2%>2</option><option value="3" %SEDA3%>aus</option></select></td><td>%SEVA%</td></tr>
    <tr class="cc"><td>[B]</td><td><input type="text" size="40" maxlength="80" name="senb" value="%SENB%"></td><td><select name="sedb"><option value="0" %SEDB0%>0</option><option value="1" %SEDB1%>1</option><option value="2" %SEDB2%>2</option><option value="3" %SEDB3%>aus</option></select></td><td>%SEVB%</td></tr>
    <tr class="cc"><td>[C]</td><td><input type="text" size="40" maxlength="80" name="senc" value="%SENC%"></td><td><select name="sedc"><option value="0" %SEDC0%>0</option><option value="1" %SEDC1%>1</option><option value="2" %SEDC2%>2</option><option value="3" %SEDC3%>aus</option></select></td><td>%SEVC%</td></tr>
    <tr class="cc"><td>[D]</td><td><input type="text" size="40" maxlength="80" name="send" value="%SEND%"></td><td><select name="sedd"><option value="0" %SEDD0%>0</option><option value="1" %SEDD1%>1</option><option value="2" %SEDD2%>2</option><option value="3" %SEDD3%>aus</option></select></td><td>%SEVD%</td></tr>
    <tr class="cc"><td>[E]</td><td><input type="text" size="40" maxlength="80" name="sene" value="%SENE%"></td><td><select name="sede"><option value="0" %SEDE0%>0</option><option value="1" %SEDE1%>1</option><option value="2" %SEDE2%>2</option><option value="3" %SEDE3%>aus</option></select></td><td>%SEVE%</td></tr>
    <tr class="cc"><td>[F]</td><td><input type="text" size="40" maxlength="80" name="senf" value="%SENF%"></td><td><select name="sedf"><option value="0" %SEDF0%>0</option><option value="1" %SEDF1%>1</option><option value="2" %SEDF2%>2</option><option value="3" %SEDF3%>aus</option></select></td><td>%SEVF%</td></tr>
    <tr class="cc"><td>[G]</td><td><input type="text" size="40" maxlength="80" name="seng" value="%SENG%"></td><td><select name="sedg"><option value="0" %SEDG0%>0</option><option value="1" %SEDG1%>1</option><option value="2" %SEDG2%>2</option><option value="3" %SEDG3%>aus</option></select></td><td>%SEVG%</td></tr>
    <tr class="cc"><td>[H]</td><td><input type="text" size="40" maxlength="80" name="senh" value="%SENH%"></td><td><select name="sedh"><option value="0" %SEDH0%>0</option><option value="1" %SEDH1%>1</option><option value="2" %SEDH2%>2</option><option value="3" %SEDH3%>aus</option></select></td><td>%SEVH%</td></tr>
    <tr class="cc"><td>[I]</td><td><input type="text" size="40" maxlength="80" name="seni" value="%SENI%"></td><td><select name="sedi"><option value="0" %SEDI0%>0</option><option value="1" %SEDI1%>1</option><option value="2" %SEDI2%>2</option><option value="3" %SEDI3%>aus</option></select></td><td>%SEVI%</td></tr>
    <tr class="cc"><td>[J]</td><td><input type="text" size="40" maxlength="80" name="senj" value="%SENJ%"></td><td><select name="sedj"><option value="0" %SEDJ0%>0</option><option value="1" %SEDJ1%>1</option><option value="2" %SEDJ2%>2</option><option value="3" %SEDJ3%>aus</option></select></td><td>%SEVJ%</td></tr>
    <tr class="cc"><td>[K]</td><td><input type="text" size="40" maxlength="80" name="senk" value="%SENK%"></td><td><select name="sedk"><option value="0" %SEDK0%>0</option><option value="1" %SEDK1%>1</option><option value="2" %SEDK2%>2</option><option value="3" %SEDK3%>aus</option></select></td><td>%SEVK%</td></tr>
    <tr class="cc"><td>[L]</td><td><input type="text" size="40" maxlength="80" name="senl" value="%SENL%"></td><td><select name="sedl"><option value="0" %SEDL0%>0</option><option value="1" %SEDL1%>1</option><option value="2" %SEDL2%>2</option><option value="3" %SEDL3%>aus</option></select></td><td>%SEVL%</td></tr>
    <tr><td colspan="4"><hr></td></tr>
    <tr><th>Name</th><th>MQTT Topic für spezielle Informationen</th><th colspan="2">Wert</th></tr>
    <tr class="cc"><td>Wetter</td><td><input type="text" size="40" maxlength="80" name="weat" value="%WEAT%"></td><td colspan="2">%WEATV%</td></tr>
    <tr class="cc"><td>Kraftstoff</td><td><input type="text" size="40" maxlength="80" name="fuel" value="%FUEL%"></td><td colspan="2">%FUELV%</td></tr>
    <tr class="cc"><td>Nachricht</td><td><input type="text" size="40" maxlength="80" name="mesg" value="%MESG%"></td><td colspan="2">%MESGV%</td></tr>
    <tr><td colspan="4"><hr></td></tr>
   </table>
   <table class="mx">
    <tr><td><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td><td class="ri"><button type="submit" formaction="/seac">Aktualisieren</button></td></tr>
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite Konfiguration, Datenausgabe
const char data_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="data">
<div class="menu">%MENU%</div>
<div class="main">
 <form action="/data" method="post">
  <fieldset>
   <legend>Datenausgabe</legend>
   <table>
    <tr><th colspan="2">Wechselanzeige</th></tr>
    <tr><td><input type="text" size="20" maxlength="20" name="dat0" value="%DAT0%"> Datenfeld 1</td><td><input type="text" size="20" maxlength="20" name="dat5" value="%DAT5%"> Datenfeld 6</td></tr>
    <tr><td><input type="text" size="20" maxlength="20" name="dat1" value="%DAT1%"> Datenfeld 2</td><td><input type="text" size="20" maxlength="20" name="dat6" value="%DAT6%"> Datenfeld 7</td></tr>
    <tr><td><input type="text" size="20" maxlength="20" name="dat2" value="%DAT2%"> Datenfeld 3</td><td><input type="text" size="20" maxlength="20" name="dat7" value="%DAT7%"> Datenfeld 8</td></tr>
    <tr><td><input type="text" size="20" maxlength="20" name="dat3" value="%DAT3%"> Datenfeld 4</td><td><input type="text" size="20" maxlength="20" name="dat8" value="%DAT8%"> Datenfeld 9</td></tr>
    <tr><td><input type="text" size="20" maxlength="20" name="dat4" value="%DAT4%"> Datenfeld 5</td><td><input type="text" size="20" maxlength="20" name="dat9" value="%DAT9%"> Datenfeld 10</td></tr>
    <tr><th colspan="2">Laufschrift</th></tr>
    <tr><td colspan="2"><input type="text" size="70" maxlength="%DSIZ%" name="data" value="%DATA%"></td></tr>
    <tr><th colspan="2">Hilfe</th></tr>
    <tr><td>[A] ... [L] <a class="ml" href="/sens">Sensoren</a> A bis L</td><td>[S] Regenmenge in mm/h (%RAI1%)</td></tr>
    <tr><td>[M] Temperatur in °C (%TEM1%)</td><td>[T] Regenmenge in mm/h (%RAI2%)</td></tr>
    <tr><td>[N] Temperatur in °C (%TEM2%)</td><td>[U] Wolkendichte in %% (%CLOU%)</td></tr>
    <tr><td>[O] Luftfeuchtigkeit in %% (%HUMI%)</td><td>[V] Windrichtungssymbol (%WINS%)</td></tr>
    <tr><td>[P] Luftdruck in hPa (%PRES%)</td><td>[W] Wettersymbol (%WEAS%)</td></tr>
    <tr><td>[Q] Wind in m/s (%WIN1%)</td><td>[X] Wetterlage (Text%WTXT%)</td></tr>
    <tr><td>[R] Wind in km/h (%WIN2%)</td><td>[Y] Sonnenzeiten (%SUNT%)</td></tr>
    <tr><td>[a] Kraftstoffpreis 1 (%FUE1%)</td><td>[e] Datum (%DATE%)</td></tr>
    <tr><td>[b] Kraftstoffpreis 2 (%FUE2%)</td><td>[f] Wochentag (%WDAY%)</td></tr>
    <tr><td>[c] Kraftstoffpreis 3 (%FUE3%)</td><td>[g] Geburtstage (%BNOW%)</td></tr>
    <tr><td>[d] Kraftstoffpreis 4 (%FUE4%)</td><td>{ ... } dynamischer Bereich</td></tr>
    <tr><td colspan="2">$T Sonnensymbol, $U Solarsymbol, $V Batteriesymbol, $W Tankensymbol</td></tr>
    <tr><td colspan="2">$X Wolkensymbol, $Y Windsymbol, $Z Regensymbol</td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><td class="le"><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td><td class="ri"><button type="submit" formaction="/daac">Aktualisieren</button></td></tr>
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite Konfiguration, Alarme
const char alms_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="alms">
<div class="menu">%MENU%</div>
<div class="main">
 <form action="/alms" method="post">
  <fieldset>
   <legend>Alarme</legend>
   <table>
    <tr><th>Nr</th><th>Sound</th><th>Halten</th><th>Text</th><th>MQTT Topic</th><th>Wert</th></tr>
    <tr class="cc"><td>1</td><td><input type="text" size="1" maxlength="1" name="als0" value="%ALS0%"></td><td><input type="checkbox" name="alh0" value="1" %ALH0%></td><td><input type="text" size="10" maxlength="20" name="atx0" value="%ATX0%"></td><td><input type="text" size="40" maxlength="80" name="ato0" value="%ATO0%"></td><td>%ALV0%</td></tr>
    <tr class="cc"><td>2</td><td><input type="text" size="1" maxlength="1" name="als1" value="%ALS1%"></td><td><input type="checkbox" name="alh1" value="1" %ALH1%></td><td><input type="text" size="10" maxlength="20" name="atx1" value="%ATX1%"></td><td><input type="text" size="40" maxlength="80" name="ato1" value="%ATO1%"></td><td>%ALV1%</td></tr>
    <tr class="cc"><td>3</td><td><input type="text" size="1" maxlength="1" name="als2" value="%ALS2%"></td><td><input type="checkbox" name="alh2" value="1" %ALH2%></td><td><input type="text" size="10" maxlength="20" name="atx2" value="%ATX2%"></td><td><input type="text" size="40" maxlength="80" name="ato2" value="%ATO2%"></td><td>%ALV2%</td></tr>
    <tr class="cc"><td>4</td><td><input type="text" size="1" maxlength="1" name="als3" value="%ALS3%"></td><td><input type="checkbox" name="alh3" value="1" %ALH3%></td><td><input type="text" size="10" maxlength="20" name="atx3" value="%ATX3%"></td><td><input type="text" size="40" maxlength="80" name="ato3" value="%ATO3%"></td><td>%ALV3%</td></tr>
    <tr><td colspan="6"><hr></td></tr>
    <tr class="cc"><th>Nr</th><th>Sound</th><th>Halten</th><th>Text</th><th>Bedingung</th><th>Wert</th></tr>
    <tr class="cc"><td>5</td><td><input type="text" size="1" maxlength="1" name="als4" value="%ALS4%"></td><td><input type="checkbox" name="alh4" value="1" %ALH4%></td><td><input type="text" size="10" maxlength="20" name="atx4" value="%ATX4%"></td><td><input type="text" size="40" maxlength="80" name="ato4" value="%ATO4%"></td><td>%ALV4%</td></tr>
    <tr class="cc"><td>6</td><td><input type="text" size="1" maxlength="1" name="als5" value="%ALS5%"></td><td><input type="checkbox" name="alh5" value="1" %ALH5%></td><td><input type="text" size="10" maxlength="20" name="atx5" value="%ATX5%"></td><td><input type="text" size="40" maxlength="80" name="ato5" value="%ATO5%"></td><td>%ALV5%</td></tr>
    <tr class="cc"><td>7</td><td><input type="text" size="1" maxlength="1" name="als6" value="%ALS6%"></td><td><input type="checkbox" name="alh6" value="1" %ALH6%></td><td><input type="text" size="10" maxlength="20" name="atx6" value="%ATX6%"></td><td><input type="text" size="40" maxlength="80" name="ato6" value="%ATO6%"></td><td>%ALV6%</td></tr>
    <tr class="cc"><td>8</td><td><input type="text" size="1" maxlength="1" name="als7" value="%ALS7%"></td><td><input type="checkbox" name="alh7" value="1" %ALH7%></td><td><input type="text" size="10" maxlength="20" name="atx7" value="%ATX7%"></td><td><input type="text" size="40" maxlength="80" name="ato7" value="%ATO7%"></td><td>%ALV7%</td></tr>
    <tr><td colspan="6"><hr></td></tr>
   </table>
   <table class="mx">
    <tr><td><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td><td class="ri"><button type="submit" formaction="/alac">Aktualisieren</button></td></tr>
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite Konfiguration, Farben
const char cols_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="cols">
<div class="menu">%MENU%</div>
<div class="main">
 <form action="/cols" method="post">
  <fieldset>
   <legend>Farben</legend>
   <table>
    <tr class="cc"><th></th><th>Zeit</th><th>Datum</th><th>Alarm</th><th>meiden</th></tr>
    <tr class="cc"><td class="cx">Zufall</td><td><input type="radio" name="col1" value="0" %C100%></td><td><input type="radio" name="col2" value="0" %C200%></td><td><input type="radio" name="col3" value="0" %C300%></td><td><input type="radio" name="col4" value="0" %C400%></td></tr>
    <tr class="cc"><td class="cx" style="background-color:#f00">&nbsp;</td><td><input type="radio" name="col1" value="1" %C101%></td><td><input type="radio" name="col2" value="1" %C201%></td><td><input type="radio" name="col3" value="1" %C301%></td><td><input type="radio" name="col4" value="1" %C401%></td></tr>
    <tr class="cc"><td class="cx" style="background-color:#f80">&nbsp;</td><td><input type="radio" name="col1" value="2" %C102%></td><td><input type="radio" name="col2" value="2" %C202%></td><td><input type="radio" name="col3" value="2" %C302%></td><td><input type="radio" name="col4" value="2" %C402%></td></tr>
    <tr class="cc"><td class="cx" style="background-color:#ff0">&nbsp;</td><td><input type="radio" name="col1" value="3" %C103%></td><td><input type="radio" name="col2" value="3" %C203%></td><td><input type="radio" name="col3" value="3" %C303%></td><td><input type="radio" name="col4" value="3" %C403%></td></tr>
    <tr class="cc"><td class="cx" style="background-color:#8f0">&nbsp;</td><td><input type="radio" name="col1" value="4" %C104%></td><td><input type="radio" name="col2" value="4" %C204%></td><td><input type="radio" name="col3" value="4" %C304%></td><td><input type="radio" name="col4" value="4" %C404%></td></tr>
    <tr class="cc"><td class="cx" style="background-color:#0f0">&nbsp;</td><td><input type="radio" name="col1" value="5" %C105%></td><td><input type="radio" name="col2" value="5" %C205%></td><td><input type="radio" name="col3" value="5" %C305%></td><td><input type="radio" name="col4" value="5" %C405%></td></tr>
    <tr class="cc"><td class="cx" style="background-color:#0f8">&nbsp;</td><td><input type="radio" name="col1" value="6" %C106%></td><td><input type="radio" name="col2" value="6" %C206%></td><td><input type="radio" name="col3" value="6" %C306%></td><td><input type="radio" name="col4" value="6" %C406%></td></tr>
    <tr class="cc"><td class="cx" style="background-color:#0ff">&nbsp;</td><td><input type="radio" name="col1" value="7" %C107%></td><td><input type="radio" name="col2" value="7" %C207%></td><td><input type="radio" name="col3" value="7" %C307%></td><td><input type="radio" name="col4" value="7" %C407%></td></tr>
    <tr class="cc"><td class="cx" style="background-color:#08f">&nbsp;</td><td><input type="radio" name="col1" value="8" %C108%></td><td><input type="radio" name="col2" value="8" %C208%></td><td><input type="radio" name="col3" value="8" %C308%></td><td><input type="radio" name="col4" value="8" %C408%></td></tr>
    <tr class="cc"><td class="cx" style="background-color:#00f">&nbsp;</td><td><input type="radio" name="col1" value="9" %C109%></td><td><input type="radio" name="col2" value="9" %C209%></td><td><input type="radio" name="col3" value="9" %C309%></td><td><input type="radio" name="col4" value="9" %C409%></td></tr>
    <tr class="cc"><td class="cx" style="background-color:#80f">&nbsp;</td><td><input type="radio" name="col1" value="10" %C110%></td><td><input type="radio" name="col2" value="10" %C210%></td><td><input type="radio" name="col3" value="10" %C310%></td><td><input type="radio" name="col4" value="10" %C410%></td></tr>
    <tr class="cc"><td class="cx" style="background-color:#f0f">&nbsp;</td><td><input type="radio" name="col1" value="11" %C111%></td><td><input type="radio" name="col2" value="11" %C211%></td><td><input type="radio" name="col3" value="11" %C311%></td><td><input type="radio" name="col4" value="11" %C411%></td></tr>
    <tr class="cc"><td class="cx" style="background-color:#f08">&nbsp;</td><td><input type="radio" name="col1" value="12" %C112%></td><td><input type="radio" name="col2" value="12" %C212%></td><td><input type="radio" name="col3" value="12" %C312%></td><td><input type="radio" name="col4" value="12" %C412%></td></tr>
    <tr class="cc"><td class="cx" style="background-color:#f88">&nbsp;</td><td><input type="radio" name="col1" value="13" %C113%></td><td><input type="radio" name="col2" value="13" %C213%></td><td><input type="radio" name="col3" value="13" %C313%></td><td><input type="radio" name="col4" value="13" %C413%></td></tr>
    <tr class="cc"><td class="cx" style="background-color:#8f8">&nbsp;</td><td><input type="radio" name="col1" value="14" %C114%></td><td><input type="radio" name="col2" value="14" %C214%></td><td><input type="radio" name="col3" value="14" %C314%></td><td><input type="radio" name="col4" value="14" %C414%></td></tr>
    <tr class="cc"><td class="cx" style="background-color:#88f">&nbsp;</td><td><input type="radio" name="col1" value="15" %C115%></td><td><input type="radio" name="col2" value="15" %C215%></td><td><input type="radio" name="col3" value="15" %C315%></td><td><input type="radio" name="col4" value="15" %C415%></td></tr>
    <tr class="cc"><td class="cx" style="background-color:#fff">&nbsp;</td><td><input type="radio" name="col1" value="16" %C116%></td><td><input type="radio" name="col2" value="16" %C216%></td><td><input type="radio" name="col3" value="16" %C316%></td><td><input type="radio" name="col4" value="16" %C416%></td></tr>
    <tr><td colspan="5"><hr></td></tr>
    <tr><td colspan="5"><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td></tr>
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite Konfiguration, Anzeige
const char disp_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="disp">
<div class="menu">%MENU%</div>
<div class="main">
 <form action="/disp" method="post">
  <fieldset>
   <legend>Anzeige</legend>
   <table>
    <tr><th colspan="2">Allgemein</th></tr>
    <tr><td><select name="disp_scrm"><option value="0" %DISPSCR0%>Wechselanzeige</option><option value="1" %DISPSCR1%>Laufschrift</option></select></td><td>Datenausgabe-Modus</td></tr>
    <tr><td><select name="disp_brch"><option value="0" %DISPBRC0%>Direkt</option><option value="1" %DISPBRC1%>Sekundentakt</option><option value="2" %DISPBRC2%>Wechselanzeige</option></select></td><td>Helligkeits-Änderungen</td></tr>
    <tr><td><input type="range" min="0" max="9" name="disp_bmin" value="%DISPBMIN%"></td><td>minimale Helligkeit</td></tr>
    <tr><td><input type="range" min="0" max="14" name="disp_bmax" value="%DISPBMAX%"></td><td>maximale Helligkeit</td></tr>
    <tr><td><input type="range" min="0" max="10" name="disp_scrl" value="%DISPSCRL%"></td><td>Scroll-Geschwindigkeit</td></tr>
    <tr><td><input type="text" size="1" maxlength="2" name="nigh_stim" value="%NIGHSTIM%"> Uhr</td><td>Nacht Beginnzeit</td></tr>
    <tr><td><input type="text" size="1" maxlength="2" name="nigh_etim" value="%NIGHETIM%"> Uhr</td><td>Nacht Endezeit</td></tr>
    <tr><td><select name="disp_mesg"><option value="0" %DISPMSG0%>bis zur Quittierung</option><option value="1" %DISPMSG1%>1 mal</option><option value="2" %DISPMSG2%>2 mal</option><option value="3" %DISPMSG3%>3 mal</option><option value="4" %DISPMSG4%>4 mal</option><option value="5" %DISPMSG5%>5 mal</option></select></td><td>Nachrichten anzeigen</td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><th colspan="2">Wechselanzeige</th></tr>
    <tr><td><select name="disp_chgt"><option value="2" %DISPCHG2%>2 Sekunden</option><option value="3" %DISPCHG3%>3 Sekunden</option><option value="4" %DISPCHG4%>4 Sekunden</option></select></td><td>Wechsel-Intervall</td></tr>
    <tr><td><input type="checkbox" name="disp_sdat" value="1" %DISPSDAT%></td><td>Datum anzeigen</td></tr>
    <tr><td><input type="checkbox" name="disp_sday" value="1" %DISPSDAY%></td><td>Wochentag anzeigen</td></tr>
    <tr><td><select name="disp_daym"><option value="0" %DISPDMO0%>Kalendertag</option><option value="1" %DISPDMO1%>Wochentag</option><option value="2" %DISPDMO2%>Wechselanzeige</option></select></td><td>Kleinanzeige-Modus</td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><th colspan="2">Laufschrift</th></tr>
    <tr><td><input type="text" size="10" maxlength="10" name="disp_sepa" value="%DISPSEPA%"></td><td>dynamisches Trenn-Element</td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><td colspan="2"><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td></tr>
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite Konfiguration, Sound
const char soun_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="soun">
<div class="menu">%MENU%</div>
<div class="main">
 <form action="/soun" method="post">
  <fieldset>
   <legend>Sound</legend>
   <table>
    <tr><td><input type="checkbox" name="soun_enab" value="1" %SOUNENAB%></td><td>Sound aktivieren</td></tr>
    <tr><td><input type="checkbox" name="soun_gong" value="1" %SOUNGONG%></td><td>Stundengong aktivieren</td></tr>
    <tr><td><input type="text" size="1" maxlength="2" name="soun_stim" value="%SOUNSTIM%"> Uhr</td><td>Sound Beginnzeit</td></tr>
    <tr><td><input type="text" size="1" maxlength="2" name="soun_etim" value="%SOUNETIM%"> Uhr</td><td>Sound Endezeit</td></tr>
    <tr><td><input type="range" min="0" max="30" name="soun_volu" value="%SOUNVOLU%"></td><td>Lautstärke</td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><td colspan="2"><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td></tr>
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite System-Einstellungen, Hardware
const char hard_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="hard">
<div class="menu">%MENU%</div>
<div class="main">
 <form action="/hard" method="post">
  <fieldset>
   <legend>Hardware</legend>
   <table>
    <tr><th></th><th class="le">Matrix</th></tr>
    <tr><td><select name="matr_clks"><option value="0" %MATRCLK0%>8 MHz</option><option value="1" %MATRCLK1%>10 MHz</option><option value="2" %MATRCLK2%>15 MHz</option><option value="3" %MATRCLK3%>20 MHz</option></select></td><td>Taktfrequenz</td></tr>
    <tr><td><select name="matr_driv"><option value="0" %MATRDRV0%>Standard</option><option value="1" %MATRDRV1%>FM6126A</option></select></td><td>Treiber-Chip</td></tr>
    <tr><td><select name="matr_latb"><option value="1" %MATRLAT1%>1</option><option value="2" %MATRLAT2%>2</option><option value="3" %MATRLAT3%>3</option><option value="4" %MATRLAT4%>4</option></select></td><td>Latch-Blanking</td></tr>
    <tr><td><input type="text" size="2" maxlength="3" name="matr_refr" value="%MATRREFR%"> Hz</td><td>Bildwiederholfrequenz</td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><th></th><th class="le">Eingabe</th></tr>
    <tr><td><select name="inpu_type"><option value="0" %INPTYPE0%>Sensor</option><option value="1" %INPTYPE1%>Taster</option></select></td><td>Eingabetyp</td></tr>
    <tr><td><select name="inpu_pnum"><option value="0" %INPPNUM0%>Pin 2</option><option value="1" %INPPNUM1%>Pin 32</option><option value="2" %INPPNUM2%>Pin 33</option></select></td><td>Anschluss</td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><td colspan="2"><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td></tr>%REBOOT%
    <tr><td colspan="2"><hr></td></tr>
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite System-Einstellungen, WLAN
const char wifi_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="wifi">
<div class="menu">%MENU%</div>
<div class="main">
 <form action="/wifi" method="post">
  <fieldset>
   <legend>WLAN</legend>
   <table>
    <tr><td><input type="text" size="20" maxlength="50" name="wifi_user" value="%SSID%"></td><td>Netzwerk (SSID)</td></tr>
    <tr><td><input type="text" size="20" maxlength="50" name="wifi_pass" value="%PASS%"></td><td>Passwort</td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><td colspan="2"><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td></tr>%REBOOT%
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite System-Einstellungen, Netzwerk
const char netw_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="netw">
<div class="menu">%MENU%</div>
<div class="main">
 <form action="/netw" method="post">
  <fieldset>
   <legend>Netzwerk</legend>
   <table>
    <tr><td><input type="checkbox" name="netw_enab" %NETWENAB% value="1"></td><td>statische IP-Adresse verwenden</td></tr>
    <tr><td><input type="text" size="20" maxlength="50" name="netw_addr" value="%NETWADDR%"></td><td>IP-Adresse</td></tr>
    <tr><td><input type="text" size="20" maxlength="50" name="netw_subn" value="%NETWSUBN%"></td><td>Subnetzmaske</td></tr>
    <tr><td><input type="text" size="20" maxlength="50" name="netw_gate" value="%NETWGATE%"></td><td>Gateway</td></tr>
    <tr><td><input type="text" size="20" maxlength="50" name="netw_dns1" value="%NETWDNS1%"></td><td>DNS</td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><td colspan="2"><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td></tr>%REBOOT%
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite System-Einstellungen, MQTT
const char mqtt_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="mqtt">
<div class="menu">%MENU%</div>
<div class="main">
 <form action="/mqtt" method="post">
  <fieldset>
   <legend>MQTT</legend>
   <table>
    <tr><td><input type="checkbox" name="mqtt_enab" %MQTTENAB% value="1"></td><td>MQTT aktivieren</td></tr>
    <tr><td><input type="text" size="40" maxlength="80" name="mqtt_addr" value="%MQTTADDR%"></td><td>Adresse des Servers</td></tr>
    <tr><td><input type="text" size="40" maxlength="80" name="mqtt_port" value="%MQTTPORT%"></td><td>Port des Servers</td></tr>
    <tr><td><input type="text" size="40" maxlength="80" name="mqtt_user" value="%MQTTUSER%"></td><td>Username</td></tr>
    <tr><td><input type="text" size="40" maxlength="80" name="mqtt_pass" value="%MQTTPASS%"></td><td>Passwort</td></tr>
    <tr><td><input type="text" size="40" maxlength="80" name="mqtt_ltop" value="%MQTTLTOP%"></td><td>LWT Topic</td></tr>
    <tr><td><input type="text" size="40" maxlength="80" name="mqtt_utop" value="%MQTTUTOP%"></td><td>Uptime Topic</td></tr>
    <tr><td><input type="text" size="40" maxlength="80" name="mqtt_rtop" value="%MQTTRTOP%"></td><td>RSSI Topic</td></tr>
    <tr><td><input type="text" size="40" maxlength="80" name="mqtt_vali" value="%MQTTVALI%"></td><td>Werte-Gültigkeit (2-60 min)</td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><td colspan="2"><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td></tr>%REBOOT%
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite System-Einstellungen, Zeit
const char time_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="time">
<div class="menu">%MENU%</div>
<div class="main">
 <form action="/time" method="post">
  <fieldset>
   <legend>Zeit</legend>
   <table>
    <tr><td><input type="text" size="30" maxlength="50" name="time_ntp1" value="%TIMENTP1%"></td><td>NTP-Server 1</td></tr>
    <tr><td><input type="text" size="30" maxlength="50" name="time_ntp2" value="%TIMENTP2%"></td><td>NTP-Server 2</td></tr>
    <tr><td><input type="text" size="30" maxlength="50" name="time_zone" value="%TIMEZONE%"></td><td>Zeitzonen-Einstellung</td></tr>
    <tr><td><select name="time_ival"><option value="5" %TIMEIV05%>5 Minuten</option><option value="10" %TIMEIV10%>10 Minuten</option><option value="15" %TIMEIV15%>15 Minuten</option><option value="30" %TIMEIV30%>30 Minuten</option><option value="60" %TIMEIV60%>60 Minuten</option></select></td><td>Sync-Intervall</td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><td colspan="2"><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td></tr>%REBOOT%
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite System-Einstellungen, Sicherheit
const char http_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="http">
<div class="menu">%MENU%</div>
<div class="main">
 <form action="/http" method="post">
  <fieldset>
   <legend>Sicherheit</legend>
   <table>
    <tr><td><input type="checkbox" name="http_enab" %HTTPENAB% value="1"></td><td>Passwortschutz aktivieren</td></tr>
    <tr><td><input type="text" size="20" maxlength="50" name="http_user" value="%HTTPUSER%"></td><td>Username für Web-Seite</td></tr>
    <tr><td><input type="text" size="20" maxlength="50" name="http_pass" value="%HTTPPASS%"></td><td>Passwort für Web-Seite</td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><td colspan="2"><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td></tr>
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite Wartung, Test-Funktionen
const char test_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="test">
<div class="menu">%MENU%</div>
<div class="main">
 <form action="/test" method="post">
  <fieldset>
   <legend>Test-Funktionen</legend>
   <table>
    <tr><th colspan="2">Anzeige</th></tr>
    <tr class="cc"><td><button class="bt" type="submit" formaction="/temn">Normal</button></td><td><button class="bt" type="submit" formaction="/temm">Farbmuster</button></td></tr>
    <tr class="cc"><td><button class="bt" type="submit" formaction="/temr">Pixel Rot</button></td><td><button class="bt" type="submit" formaction="/temg">Pixel Grün</button></td></tr>
    <tr class="cc"><td><button class="bt" type="submit" formaction="/temb">Pixel Blau</button></td><td><button class="bt" type="submit" formaction="/temw">Pixel Weiß</button></td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><th colspan="2">Sound</th></tr>
    <tr class="cc"><td><button class="bt" type="submit" formaction="/tes1">Sound 1</button></td><td><button class="bt" type="submit" formaction="/tes2">Sound 2</button></td></tr>
    <tr class="cc"><td><button class="bt" type="submit" formaction="/tes3">Sound 3</button></td><td><button class="bt" type="submit" formaction="/tes4">Sound 4</button></td></tr>
    <tr class="cc"><td><button class="bt" type="submit" formaction="/tes5">Sound 5</button></td><td><button class="bt" type="submit" formaction="/tes6">Sound 6</button></td></tr>
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite Wartung, Datei-Manager
const char file_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="file">
<div class="menu">%MENU%</div>
<div class="main">
 <form action="/file" method="post">
  <fieldset>
   <legend>Datei-Manager</legend>
   <table>
    <tr class="cc"><th>Nummer</th><th class="le">Dateiname</th><th>Bytes</th><th>Zeit</th></tr>
%FILELIST%    <tr><td colspan="4"><hr></td></tr>
    <tr class="cc"><td><input type="text" size="1" maxlength="3" name="file_numb" value=""></td><td><button type="submit" %DISAB%>Download</button></td><td><button type="submit" formaction="/fdel" %DISAB%>Löschen</button></td><td></td></tr>
   </table>
  </fieldset>
 </form>
 <form action="/upld" method="post" enctype="multipart/form-data">
  <fieldset>
   <legend>Upload</legend>
   <table>
    <tr><td><input type="file" name="data"></td><td></td></tr>
    <tr><td><input type="submit" name="file_upld" value="Upload" %DISAB%></td><td></td></tr>%REBOOT%
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite Wartung, Firmware-Update
const char fwup_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="fwup">
<div class="menu">%MENU%</div>
<div class="main">
 <form action="/fwup" method="post" enctype="multipart/form-data">
  <fieldset>
   <legend>Firmware-Update</legend>
   <table>
    <tr><td><input type="file" name="data"></td><td></td></tr>
    <tr><td><input type="submit" name="fwup" value="Update">&nbsp; %SAVE%</td><td></td></tr>%REBOOT%
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Platzhalter-Variablen im HTML-Text ersetzen
String processor(const String& var) {                                 // Variable lesen und durch einen String ersetzen
  uint i;                                                             // Zählervariable
  String s;                                                           // String-Zwischenspeicher
  if (var == "HEADER") return header;                                 // HTML-Header und CSS-Definitionen einsetzen
  if (var == "MENU") return leftmenu;                                 // Linkes Seitenmenü einsetzen
  if (var == "VERSION") return string00;                              // Software-Version einsetzen
  if (var == "VDATE") return string20;                                // Software-Datum einsetzen
  if (var == "UPTIME") return uptimex;                                // dynamische Systemlaufzeit einsetzen
  if (var == "SSID") return percentmask(wifi_ssid);                   // WLAN-SSID einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "PASS") return percentmask(wifi_pass);                   // WLAN-Passwort einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "RSSI") return String(rssi);                             // WLAN-Empfangssignal einsetzen
  if (var == "DISAB") return filestat? "": disabled;                  // wenn Dateisystem nicht vorhanden -> Speichern-Button deaktivieren
  if (var == "FILESYS") return filestat? status_green: status_red;    // Dateisystemstatus einsetzen
  if (var == "MQTT") return mqttstat? status_green: status_red;       // MQTT-Verbindungsstatus einsetzen
  if (var == "REBOOT") return reboot? reboot_msg: "";                 // wenn Reboot und Neustart erforderlich -> Neustart-Meldung einsetzen
  if (var == "TIMESYNC") {                                            // wenn Status der Zeitsynchronisierung
    if (syncstat == 0) return status_red;                             // wenn nicht synchronisiert -> Status rot
    if (syncstat == 1) return status_orange;                          // wenn Synchronisierung überfällig -> Status orange
    if (syncstat == 2) return status_green;                           // wenn synchronisiert -> Status grün
  }
  if (var == "SAVE") {                                                // wenn Status der letzten Speicheraktion
    if (save == 0) return "";                                         // wenn keine Anzeige -> leerer String
    if (save == 1) return result_green;                               // wenn Status ok -> Ergebnis ok
    if (save == 2) return result_red;                                 // wenn Status Fehler -> Ergebnis Fehler
  }
  if (var == "CHIPMOD") return ESP.getChipModel();                    // Chip-Modell einsetzen
  if (var == "CHIPVER") return String(ESP.getChipRevision() / 100) + "." + String(ESP.getChipRevision() % 100); // Chip-Version einsetzen
  if (var == "CPUFREQ") return String(ESP.getCpuFreqMHz());           // CPU-Frequenz einsetzen
  if (var == "FLSHSIZE") return String(ESP.getFlashChipSize());       // Flash-Speichergröße einsetzen
  if (var == "HEAPSIZE") return String(ESP.getHeapSize());            // Arbeitsspeicher einsetzen
  if (var == "FREEHEAP") return String(ESP.getFreeHeap());            // freien Speicher einsetzen
  if (var == "MUTE") return mute? status_ein: status_aus;             // Stummschaltung einsetzen
  if (var == "MESSAGE") return percentmask(message);                  // Nachricht einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "C100" && colorclk == 0) return checked;                 // wenn Farbe 1 Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "C101" && colorclk == 1) return checked;                 // wenn Farbe 1 Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "C102" && colorclk == 2) return checked;                 // wenn Farbe 1 Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "C103" && colorclk == 3) return checked;                 // wenn Farbe 1 Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "C104" && colorclk == 4) return checked;                 // wenn Farbe 1 Option 4 und Einstellung 4 aktiv -> Option aktivieren
  if (var == "C105" && colorclk == 5) return checked;                 // wenn Farbe 1 Option 5 und Einstellung 5 aktiv -> Option aktivieren
  if (var == "C106" && colorclk == 6) return checked;                 // wenn Farbe 1 Option 6 und Einstellung 6 aktiv -> Option aktivieren
  if (var == "C107" && colorclk == 7) return checked;                 // wenn Farbe 1 Option 7 und Einstellung 7 aktiv -> Option aktivieren
  if (var == "C108" && colorclk == 8) return checked;                 // wenn Farbe 1 Option 8 und Einstellung 8 aktiv -> Option aktivieren
  if (var == "C109" && colorclk == 9) return checked;                 // wenn Farbe 1 Option 9 und Einstellung 9 aktiv -> Option aktivieren
  if (var == "C110" && colorclk == 10) return checked;                // wenn Farbe 1 Option 11 und Einstellung 10 aktiv -> Option aktivieren
  if (var == "C111" && colorclk == 11) return checked;                // wenn Farbe 1 Option 12 und Einstellung 11 aktiv -> Option aktivieren
  if (var == "C112" && colorclk == 12) return checked;                // wenn Farbe 1 Option 13 und Einstellung 12 aktiv -> Option aktivieren
  if (var == "C113" && colorclk == 13) return checked;                // wenn Farbe 1 Option 14 und Einstellung 13 aktiv -> Option aktivieren
  if (var == "C114" && colorclk == 14) return checked;                // wenn Farbe 1 Option 15 und Einstellung 14 aktiv -> Option aktivieren
  if (var == "C115" && colorclk == 15) return checked;                // wenn Farbe 1 Option 16 und Einstellung 15 aktiv -> Option aktivieren
  if (var == "C116" && colorclk == 16) return checked;                // wenn Farbe 1 Option 17 und Einstellung 16 aktiv -> Option aktivieren
  if (var == "C200" && colordat == 0) return checked;                 // wenn Farbe 2 Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "C201" && colordat == 1) return checked;                 // wenn Farbe 2 Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "C202" && colordat == 2) return checked;                 // wenn Farbe 2 Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "C203" && colordat == 3) return checked;                 // wenn Farbe 2 Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "C204" && colordat == 4) return checked;                 // wenn Farbe 2 Option 4 und Einstellung 4 aktiv -> Option aktivieren
  if (var == "C205" && colordat == 5) return checked;                 // wenn Farbe 2 Option 5 und Einstellung 5 aktiv -> Option aktivieren
  if (var == "C206" && colordat == 6) return checked;                 // wenn Farbe 2 Option 6 und Einstellung 6 aktiv -> Option aktivieren
  if (var == "C207" && colordat == 7) return checked;                 // wenn Farbe 2 Option 7 und Einstellung 7 aktiv -> Option aktivieren
  if (var == "C208" && colordat == 8) return checked;                 // wenn Farbe 2 Option 8 und Einstellung 8 aktiv -> Option aktivieren
  if (var == "C209" && colordat == 9) return checked;                 // wenn Farbe 2 Option 9 und Einstellung 9 aktiv -> Option aktivieren
  if (var == "C210" && colordat == 10) return checked;                // wenn Farbe 2 Option 10 und Einstellung 10 aktiv -> Option aktivieren
  if (var == "C211" && colordat == 11) return checked;                // wenn Farbe 2 Option 11 und Einstellung 11 aktiv -> Option aktivieren
  if (var == "C212" && colordat == 12) return checked;                // wenn Farbe 2 Option 12 und Einstellung 12 aktiv -> Option aktivieren
  if (var == "C213" && colordat == 13) return checked;                // wenn Farbe 2 Option 13 und Einstellung 13 aktiv -> Option aktivieren
  if (var == "C214" && colordat == 14) return checked;                // wenn Farbe 2 Option 14 und Einstellung 14 aktiv -> Option aktivieren
  if (var == "C215" && colordat == 15) return checked;                // wenn Farbe 2 Option 15 und Einstellung 15 aktiv -> Option aktivieren
  if (var == "C216" && colordat == 16) return checked;                // wenn Farbe 2 Option 16 und Einstellung 16 aktiv -> Option aktivieren
  if (var == "C300" && coloralm == 0) return checked;                 // wenn Farbe 3 Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "C301" && coloralm == 1) return checked;                 // wenn Farbe 3 Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "C302" && coloralm == 2) return checked;                 // wenn Farbe 3 Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "C303" && coloralm == 3) return checked;                 // wenn Farbe 3 Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "C304" && coloralm == 4) return checked;                 // wenn Farbe 3 Option 4 und Einstellung 4 aktiv -> Option aktivieren
  if (var == "C305" && coloralm == 5) return checked;                 // wenn Farbe 3 Option 5 und Einstellung 5 aktiv -> Option aktivieren
  if (var == "C306" && coloralm == 6) return checked;                 // wenn Farbe 3 Option 6 und Einstellung 6 aktiv -> Option aktivieren
  if (var == "C307" && coloralm == 7) return checked;                 // wenn Farbe 3 Option 7 und Einstellung 7 aktiv -> Option aktivieren
  if (var == "C308" && coloralm == 8) return checked;                 // wenn Farbe 3 Option 8 und Einstellung 8 aktiv -> Option aktivieren
  if (var == "C309" && coloralm == 9) return checked;                 // wenn Farbe 3 Option 9 und Einstellung 9 aktiv -> Option aktivieren
  if (var == "C310" && coloralm == 10) return checked;                // wenn Farbe 3 Option 10 und Einstellung 10 aktiv -> Option aktivieren
  if (var == "C311" && coloralm == 11) return checked;                // wenn Farbe 3 Option 11 und Einstellung 11 aktiv -> Option aktivieren
  if (var == "C312" && coloralm == 12) return checked;                // wenn Farbe 3 Option 12 und Einstellung 12 aktiv -> Option aktivieren
  if (var == "C313" && coloralm == 13) return checked;                // wenn Farbe 3 Option 13 und Einstellung 13 aktiv -> Option aktivieren
  if (var == "C314" && coloralm == 14) return checked;                // wenn Farbe 3 Option 14 und Einstellung 14 aktiv -> Option aktivieren
  if (var == "C315" && coloralm == 15) return checked;                // wenn Farbe 3 Option 15 und Einstellung 15 aktiv -> Option aktivieren
  if (var == "C316" && coloralm == 16) return checked;                // wenn Farbe 3 Option 16 und Einstellung 16 aktiv -> Option aktivieren
  if (var == "C400" && coloravo == 0) return checked;                 // wenn Farbe 4 Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "C401" && coloravo == 1) return checked;                 // wenn Farbe 4 Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "C402" && coloravo == 2) return checked;                 // wenn Farbe 4 Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "C403" && coloravo == 3) return checked;                 // wenn Farbe 4 Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "C404" && coloravo == 4) return checked;                 // wenn Farbe 4 Option 4 und Einstellung 4 aktiv -> Option aktivieren
  if (var == "C405" && coloravo == 5) return checked;                 // wenn Farbe 4 Option 5 und Einstellung 5 aktiv -> Option aktivieren
  if (var == "C406" && coloravo == 6) return checked;                 // wenn Farbe 4 Option 6 und Einstellung 6 aktiv -> Option aktivieren
  if (var == "C407" && coloravo == 7) return checked;                 // wenn Farbe 4 Option 7 und Einstellung 7 aktiv -> Option aktivieren
  if (var == "C408" && coloravo == 8) return checked;                 // wenn Farbe 4 Option 8 und Einstellung 8 aktiv -> Option aktivieren
  if (var == "C409" && coloravo == 9) return checked;                 // wenn Farbe 4 Option 9 und Einstellung 9 aktiv -> Option aktivieren
  if (var == "C410" && coloravo == 10) return checked;                // wenn Farbe 4 Option 10 und Einstellung 10 aktiv -> Option aktivieren
  if (var == "C411" && coloravo == 11) return checked;                // wenn Farbe 4 Option 11 und Einstellung 11 aktiv -> Option aktivieren
  if (var == "C412" && coloravo == 12) return checked;                // wenn Farbe 4 Option 12 und Einstellung 12 aktiv -> Option aktivieren
  if (var == "C413" && coloravo == 13) return checked;                // wenn Farbe 4 Option 13 und Einstellung 13 aktiv -> Option aktivieren
  if (var == "C414" && coloravo == 14) return checked;                // wenn Farbe 4 Option 14 und Einstellung 14 aktiv -> Option aktivieren
  if (var == "C415" && coloravo == 15) return checked;                // wenn Farbe 4 Option 15 und Einstellung 15 aktiv -> Option aktivieren
  if (var == "C416" && coloravo == 16) return checked;                // wenn Farbe 4 Option 16 und Einstellung 16 aktiv -> Option aktivieren
  if (var == "DISPCHG2" && chgtime == 2) return selected;             // wenn Wechselzeit-Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "DISPCHG3" && chgtime == 3) return selected;             // wenn Wechselzeit-Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "DISPCHG4" && chgtime == 4) return selected;             // wenn Wechselzeit-Option 4 und Einstellung 4 aktiv -> Option aktivieren
  if (var == "DISPSDAT") return showdate? checked: "";                // wenn Datumanzeige aktiviert -> Checkbox aktivieren
  if (var == "DISPSDAY") return showday? checked: "";                 // wenn Wochentaganzeige aktiviert -> Checkbox aktivieren
  if (var == "DISPDMO0" && smallmode == 0) return selected;           // wenn Kleinanzeige-Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "DISPDMO1" && smallmode == 1) return selected;           // wenn Kleinanzeige-Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "DISPDMO2" && smallmode == 2) return selected;           // wenn Kleinanzeige-Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "DISPSCR0" && scrollmode == 0) return selected;          // wenn Datenausgabe-Modus-Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "DISPSCR1" && scrollmode == 1) return selected;          // wenn Datenausgabe-Modus-Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "DISPMSG0" && msg_count == 0) return selected;           // wenn Nachrichten-Anzeige-Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "DISPMSG1" && msg_count == 1) return selected;           // wenn Nachrichten-Anzeige-Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "DISPMSG2" && msg_count == 2) return selected;           // wenn Nachrichten-Anzeige-Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "DISPMSG3" && msg_count == 3) return selected;           // wenn Nachrichten-Anzeige-Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "DISPMSG4" && msg_count == 4) return selected;           // wenn Nachrichten-Anzeige-Option 4 und Einstellung 4 aktiv -> Option aktivieren
  if (var == "DISPMSG5" && msg_count == 5) return selected;           // wenn Nachrichten-Anzeige-Option 5 und Einstellung 5 aktiv -> Option aktivieren
  if (var == "DISPBRC0" && brightchg == 0) return selected;           // wenn Helligkeits-Änderung-Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "DISPBRC1" && brightchg == 1) return selected;           // wenn Helligkeits-Änderung-Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "DISPBRC2" && brightchg == 2) return selected;           // wenn Helligkeits-Änderung-Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "NIGHSTIM") return String(night_stim);                   // Nacht-Beginnzeit einsetzen
  if (var == "NIGHETIM") return String(night_etim);                   // Nacht-Endezeit einsetzen
  if (var == "DISPBMIN") return String(brightmin);                    // minimale Helligkeit einsetzen
  if (var == "DISPBMAX") return String(brightmax);                    // maximale Helligkeit einsetzen
  if (var == "DISPSCRL") return String(scrolltime);                   // Scroll-Geschwindigkeit einsetzen
  if (var == "DISPSEPA") return String(separator);                    // Dynamisches Trennzeichen einsetzen
  if (var == "MATRCLK0" && matr_clks == 0) return selected;           // wenn Matrix-Takt-Option 0 und Taktfrequenz-Einstellung 0 aktiv -> Option aktivieren
  if (var == "MATRCLK1" && matr_clks == 1) return selected;           // wenn Matrix-Takt-Option 1 und Taktfrequenz-Einstellung 1 aktiv -> Option aktivieren
  if (var == "MATRCLK2" && matr_clks == 2) return selected;           // wenn Matrix-Takt-Option 2 und Taktfrequenz-Einstellung 2 aktiv -> Option aktivieren
  if (var == "MATRCLK3" && matr_clks == 3) return selected;           // wenn Matrix-Takt-Option 3 und Taktfrequenz-Einstellung 3 aktiv -> Option aktivieren
  if (var == "MATRDRV0" && matr_driv == 0) return selected;           // wenn Matrix-Treiber-Chip-Option 0 und Treiber-Chip-Einstellung 0 aktiv -> Option aktivieren
  if (var == "MATRDRV1" && matr_driv == 1) return selected;           // wenn Matrix-Treiber-Chip-Option 1 und Treiber-Chip-Einstellung 1 aktiv -> Option aktivieren
  if (var == "MATRLAT1" && matr_latb == 1) return selected;           // wenn Matrix-Latch-Blanking-Option 1 und Latch-Blanking-Einstellung 1 aktiv -> Option aktivieren
  if (var == "MATRLAT2" && matr_latb == 2) return selected;           // wenn Matrix-Latch-Blanking-Option 2 und Latch-Blanking-Einstellung 2 aktiv -> Option aktivieren
  if (var == "MATRLAT3" && matr_latb == 3) return selected;           // wenn Matrix-Latch-Blanking-Option 3 und Latch-Blanking-Einstellung 3 aktiv -> Option aktivieren
  if (var == "MATRLAT4" && matr_latb == 4) return selected;           // wenn Matrix-Latch-Blanking-Option 4 und Latch-Blanking-Einstellung 4 aktiv -> Option aktivieren
  if (var == "MATRREFR") return String(matr_refr);                    // Matrix-Bildwiederholfrequenz einsetzen
  if (var == "INPTYPE0" && input_type == 0) return selected;          // wenn Eingabe-Typ-Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "INPTYPE1" && input_type == 1) return selected;          // wenn Eingabe-Typ-Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "INPPNUM0" && input_pnum == 0) return selected;          // wenn Eingabe-Pin-Nummer-Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "INPPNUM1" && input_pnum == 1) return selected;          // wenn Eingabe-Pin-Nummer-Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "INPPNUM2" && input_pnum == 2) return selected;          // wenn Eingabe-Pin-Nummer-Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "NETWENAB") return netw_enab? checked: "";               // wenn statische IP-Adresse aktiviert -> Checkbox aktivieren
  if (var == "NETWADDR") return percentmask(netw_addr);               // IP-Adresse einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "NETWSUBN") return percentmask(netw_subn);               // Subnetzmaske einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "NETWGATE") return percentmask(netw_gate);               // Gateway einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "NETWDNS1") return percentmask(netw_dns1);               // DNS einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "TIMENTP1") return percentmask(time_ntp1);               // NTP-Server 1 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "TIMENTP2") return percentmask(time_ntp2);               // NTP-Server 2 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "TIMEZONE") return percentmask(time_zone);               // Zeitzonen-Einstellungen einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "TIMEIV05" && time_ival == 5) return selected;           // wenn Sync-Intervall-Option 5 und Sync-Intervall 5 aktiv -> Option aktivieren
  if (var == "TIMEIV10" && time_ival == 10) return selected;          // wenn Sync-Intervall-Option 10 und Sync-Intervall 10 aktiv -> Option aktivieren
  if (var == "TIMEIV15" && time_ival == 15) return selected;          // wenn Sync-Intervall-Option 15 und Sync-Intervall 15 aktiv -> Option aktivieren
  if (var == "TIMEIV30" && time_ival == 30) return selected;          // wenn Sync-Intervall-Option 30 und Sync-Intervall 30 aktiv -> Option aktivieren
  if (var == "TIMEIV60" && time_ival == 60) return selected;          // wenn Sync-Intervall-Option 60 und Sync-Intervall 60 aktiv -> Option aktivieren
  if (var == "MQTTENAB") return mqtt_enab? checked: "";               // wenn MQTT aktiviert -> Checkbox aktivieren
  if (var == "MQTTADDR") return percentmask(mqtt_addr);               // MQTT-Adresse einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "MQTTPORT") return percentmask(mqtt_port);               // MQTT-Port einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "MQTTUSER") return percentmask(mqtt_user);               // MQTT-Username einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "MQTTPASS") return percentmask(mqtt_pass);               // MQTT-Passwort einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "MQTTLTOP") return percentmask(mqtt_ltop);               // MQTT LWT-Topic einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "MQTTUTOP") return percentmask(mqtt_utop);               // MQTT Uptime-Topic einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "MQTTRTOP") return percentmask(mqtt_rtop);               // MQTT RSSI-Topic einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "MQTTVALI") return String(mqtt_vali);                    // MQTT Werte-Gültigkeit einsetzen
  if (var == "HTTPENAB") return http_enab? checked: "";               // wenn HTTP-Authentifizierung aktiviert -> Checkbox aktivieren
  if (var == "HTTPUSER") return percentmask(http_user);               // HTTP-Username einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "HTTPPASS") return percentmask(http_pass);               // HTTP-Passwort einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "FILELIST") return filelist;                             // Dateiliste einsetzen
  if (var == "BDAYLIST") return bdaylist;                             // Geburtstagsliste einsetzen
  if (var == "BDAYPAGE") return String(bdaypage + 1);                 // aktuelle Seite der Geburtstagsliste einsetzen
  if (var == "BDDISAB") {
    if (!filestat || bdaycount >= MAXBDAYS) return disabled; else return ""; // wenn Dateisystem nicht vorhanden oder Geburtstagsliste voll -> Plus-Button deaktivieren
  }
  if (var == "SENA") return percentmask(sensorlist[0]);               // MQTT-Topic von Sensor A einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SENB") return percentmask(sensorlist[1]);               // MQTT-Topic von Sensor B einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SENC") return percentmask(sensorlist[2]);               // MQTT-Topic von Sensor C einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEND") return percentmask(sensorlist[3]);               // MQTT-Topic von Sensor D einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SENE") return percentmask(sensorlist[4]);               // MQTT-Topic von Sensor E einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SENF") return percentmask(sensorlist[5]);               // MQTT-Topic von Sensor F einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SENG") return percentmask(sensorlist[6]);               // MQTT-Topic von Sensor G einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SENH") return percentmask(sensorlist[7]);               // MQTT-Topic von Sensor H einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SENI") return percentmask(sensorlist[8]);               // MQTT-Topic von Sensor I einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SENJ") return percentmask(sensorlist[9]);               // MQTT-Topic von Sensor J einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SENK") return percentmask(sensorlist[10]);              // MQTT-Topic von Sensor K einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SENL") return percentmask(sensorlist[11]);              // MQTT-Topic von Sensor L einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "WEAT") return percentmask(sensorlist[12]);              // MQTT-Topic von Wettersensor einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "FUEL") return percentmask(sensorlist[13]);              // MQTT-Topic von Kraftstoffsensor einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "MESG") return percentmask(sensorlist[14]);              // MQTT-Topic von Textnachricht einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEDA0" && sensordeci[0] == 0) return selected;          // wenn Nachkommastelle von Sensor A Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDA1" && sensordeci[0] == 1) return selected;          // wenn Nachkommastelle von Sensor A Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDA2" && sensordeci[0] == 2) return selected;          // wenn Nachkommastelle von Sensor A Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDA3" && sensordeci[0] == 3) return selected;          // wenn Nachkommastelle von Sensor A Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEDB0" && sensordeci[1] == 0) return selected;          // wenn Nachkommastelle von Sensor B Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDB1" && sensordeci[1] == 1) return selected;          // wenn Nachkommastelle von Sensor B Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDB2" && sensordeci[1] == 2) return selected;          // wenn Nachkommastelle von Sensor B Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDB3" && sensordeci[1] == 3) return selected;          // wenn Nachkommastelle von Sensor B Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEDC0" && sensordeci[2] == 0) return selected;          // wenn Nachkommastelle von Sensor C Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDC1" && sensordeci[2] == 1) return selected;          // wenn Nachkommastelle von Sensor C Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDC2" && sensordeci[2] == 2) return selected;          // wenn Nachkommastelle von Sensor C Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDC3" && sensordeci[2] == 3) return selected;          // wenn Nachkommastelle von Sensor C Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEDD0" && sensordeci[3] == 0) return selected;          // wenn Nachkommastelle von Sensor D Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDD1" && sensordeci[3] == 1) return selected;          // wenn Nachkommastelle von Sensor D Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDD2" && sensordeci[3] == 2) return selected;          // wenn Nachkommastelle von Sensor D Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDD3" && sensordeci[3] == 3) return selected;          // wenn Nachkommastelle von Sensor D Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEDE0" && sensordeci[4] == 0) return selected;          // wenn Nachkommastelle von Sensor E Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDE1" && sensordeci[4] == 1) return selected;          // wenn Nachkommastelle von Sensor E Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDE2" && sensordeci[4] == 2) return selected;          // wenn Nachkommastelle von Sensor E Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDE3" && sensordeci[4] == 3) return selected;          // wenn Nachkommastelle von Sensor E Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEDF0" && sensordeci[5] == 0) return selected;          // wenn Nachkommastelle von Sensor F Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDF1" && sensordeci[5] == 1) return selected;          // wenn Nachkommastelle von Sensor F Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDF2" && sensordeci[5] == 2) return selected;          // wenn Nachkommastelle von Sensor F Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDF3" && sensordeci[5] == 3) return selected;          // wenn Nachkommastelle von Sensor F Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEDG0" && sensordeci[6] == 0) return selected;          // wenn Nachkommastelle von Sensor G Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDG1" && sensordeci[6] == 1) return selected;          // wenn Nachkommastelle von Sensor G Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDG2" && sensordeci[6] == 2) return selected;          // wenn Nachkommastelle von Sensor G Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDG3" && sensordeci[6] == 3) return selected;          // wenn Nachkommastelle von Sensor G Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEDH0" && sensordeci[7] == 0) return selected;          // wenn Nachkommastelle von Sensor H Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDH1" && sensordeci[7] == 1) return selected;          // wenn Nachkommastelle von Sensor H Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDH2" && sensordeci[7] == 2) return selected;          // wenn Nachkommastelle von Sensor H Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDH3" && sensordeci[7] == 3) return selected;          // wenn Nachkommastelle von Sensor H Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEDI0" && sensordeci[8] == 0) return selected;          // wenn Nachkommastelle von Sensor I Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDI1" && sensordeci[8] == 1) return selected;          // wenn Nachkommastelle von Sensor I Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDI2" && sensordeci[8] == 2) return selected;          // wenn Nachkommastelle von Sensor I Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDI3" && sensordeci[8] == 3) return selected;          // wenn Nachkommastelle von Sensor I Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEDJ0" && sensordeci[9] == 0) return selected;          // wenn Nachkommastelle von Sensor J Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDJ1" && sensordeci[9] == 1) return selected;          // wenn Nachkommastelle von Sensor J Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDJ2" && sensordeci[9] == 2) return selected;          // wenn Nachkommastelle von Sensor J Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDJ3" && sensordeci[9] == 3) return selected;          // wenn Nachkommastelle von Sensor J Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEDK0" && sensordeci[10] == 0) return selected;         // wenn Nachkommastelle von Sensor K Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDK1" && sensordeci[10] == 1) return selected;         // wenn Nachkommastelle von Sensor K Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDK2" && sensordeci[10] == 2) return selected;         // wenn Nachkommastelle von Sensor K Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDK3" && sensordeci[10] == 3) return selected;         // wenn Nachkommastelle von Sensor K Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEDL0" && sensordeci[11] == 0) return selected;         // wenn Nachkommastelle von Sensor L Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDL1" && sensordeci[11] == 1) return selected;         // wenn Nachkommastelle von Sensor L Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDL2" && sensordeci[11] == 2) return selected;         // wenn Nachkommastelle von Sensor L Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDL3" && sensordeci[11] == 3) return selected;         // wenn Nachkommastelle von Sensor L Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEVA") return percentmask(sensorvals[0]);               // Wert von Sensor A einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEVB") return percentmask(sensorvals[1]);               // Wert von Sensor B einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEVC") return percentmask(sensorvals[2]);               // Wert von Sensor C einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEVD") return percentmask(sensorvals[3]);               // Wert von Sensor D einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEVE") return percentmask(sensorvals[4]);               // Wert von Sensor E einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEVF") return percentmask(sensorvals[5]);               // Wert von Sensor F einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEVG") return percentmask(sensorvals[6]);               // Wert von Sensor G einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEVH") return percentmask(sensorvals[7]);               // Wert von Sensor H einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEVI") return percentmask(sensorvals[8]);               // Wert von Sensor I einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEVJ") return percentmask(sensorvals[9]);               // Wert von Sensor J einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEVK") return percentmask(sensorvals[10]);              // Wert von Sensor K einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEVL") return percentmask(sensorvals[11]);              // Wert von Sensor L einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "WEATV") return percentmask(weatv);                      // Anfang der Wetterdaten einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "FUELV") return percentmask(fuelv);                      // Anfang der Kraftstoffdaten einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "MESGV") return percentmask(mesgv);                      // Anfang der Textnachricht einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "DAT0") return percentmask(datadisp[0]);                 // Datenausgabe Datenfeld 1 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "DAT1") return percentmask(datadisp[1]);                 // Datenausgabe Datenfeld 2 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "DAT2") return percentmask(datadisp[2]);                 // Datenausgabe Datenfeld 3 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "DAT3") return percentmask(datadisp[3]);                 // Datenausgabe Datenfeld 4 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "DAT4") return percentmask(datadisp[4]);                 // Datenausgabe Datenfeld 5 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "DAT5") return percentmask(datadisp[5]);                 // Datenausgabe Datenfeld 6 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "DAT6") return percentmask(datadisp[6]);                 // Datenausgabe Datenfeld 7 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "DAT7") return percentmask(datadisp[7]);                 // Datenausgabe Datenfeld 8 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "DAT8") return percentmask(datadisp[8]);                 // Datenausgabe Datenfeld 9 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "DAT9") return percentmask(datadisp[9]);                 // Datenausgabe Datenfeld 10 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "DATA") return percentmask(datadisp_scr);                // Datenausgabe Datenfeld für Laufschrift einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "DSIZ") return String(DATASIZE);                         // Datenfeldlänge einsetzen
  if (var == "DATE") return (syncstat > 0)? curdate: stringsd[9];     // Datum einsetzen
  if (var == "WDAY") return (syncstat > 0)? stringsd[wday]: stringsd[10]; // Wochentag einsetzen
  if (var == "ALS0") return String(alarmsound[0]);                    // Soundnummer von Alarm 1 einsetzen
  if (var == "ALS1") return String(alarmsound[1]);                    // Soundnummer von Alarm 2 einsetzen
  if (var == "ALS2") return String(alarmsound[2]);                    // Soundnummer von Alarm 3 einsetzen
  if (var == "ALS3") return String(alarmsound[3]);                    // Soundnummer von Alarm 4 einsetzen
  if (var == "ALS4") return String(alarmsound[4]);                    // Soundnummer von Alarm 5 einsetzen
  if (var == "ALS5") return String(alarmsound[5]);                    // Soundnummer von Alarm 6 einsetzen
  if (var == "ALS6") return String(alarmsound[6]);                    // Soundnummer von Alarm 7 einsetzen
  if (var == "ALS7") return String(alarmsound[7]);                    // Soundnummer von Alarm 8 einsetzen
  if (var == "ALH0") return alarmhold[0]? checked: "";                // wenn Haltemodus Alarm 1 aktiviert -> Option aktivieren
  if (var == "ALH1") return alarmhold[1]? checked: "";                // wenn Haltemodus Alarm 2 aktiviert -> Option aktivieren
  if (var == "ALH2") return alarmhold[2]? checked: "";                // wenn Haltemodus Alarm 3 aktiviert -> Option aktivieren
  if (var == "ALH3") return alarmhold[3]? checked: "";                // wenn Haltemodus Alarm 4 aktiviert -> Option aktivieren
  if (var == "ALH4") return alarmhold[4]? checked: "";                // wenn Haltemodus Alarm 5 aktiviert -> Option aktivieren
  if (var == "ALH5") return alarmhold[5]? checked: "";                // wenn Haltemodus Alarm 6 aktiviert -> Option aktivieren
  if (var == "ALH6") return alarmhold[6]? checked: "";                // wenn Haltemodus Alarm 7 aktiviert -> Option aktivieren
  if (var == "ALH7") return alarmhold[7]? checked: "";                // wenn Haltemodus Alarm 8 aktiviert -> Option aktivieren
  if (var == "ATX0") return percentmask(alarmtext[0]);                // Alarmtext von Alarm 1 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ATX1") return percentmask(alarmtext[1]);                // Alarmtext von Alarm 2 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ATX2") return percentmask(alarmtext[2]);                // Alarmtext von Alarm 3 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ATX3") return percentmask(alarmtext[3]);                // Alarmtext von Alarm 4 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ATX4") return percentmask(alarmtext[4]);                // Alarmtext von Alarm 5 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ATX5") return percentmask(alarmtext[5]);                // Alarmtext von Alarm 6 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ATX6") return percentmask(alarmtext[6]);                // Alarmtext von Alarm 7 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ATX7") return percentmask(alarmtext[7]);                // Alarmtext von Alarm 8 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ATO0") return percentmask(alarmlist[0]);                // MQTT-Topic von Alarm 1 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ATO1") return percentmask(alarmlist[1]);                // MQTT-Topic von Alarm 2 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ATO2") return percentmask(alarmlist[2]);                // MQTT-Topic von Alarm 3 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ATO3") return percentmask(alarmlist[3]);                // MQTT-Topic von Alarm 4 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ATO4") return percentmask(alarmlist[4]);                // Bedingung von Alarm 5 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ATO5") return percentmask(alarmlist[5]);                // Bedingung von Alarm 6 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ATO6") return percentmask(alarmlist[6]);                // Bedingung von Alarm 7 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ATO7") return percentmask(alarmlist[7]);                // Bedingung von Alarm 8 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ALV0") return percentmask(alarmvals[0]);                // Wert von Alarm 1 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ALV1") return percentmask(alarmvals[1]);                // Wert von Alarm 2 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ALV2") return percentmask(alarmvals[2]);                // Wert von Alarm 3 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ALV3") return percentmask(alarmvals[3]);                // Wert von Alarm 4 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ALV4") return percentmask(alarmvals[4]);                // Wert von Alarm 5 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ALV5") return percentmask(alarmvals[5]);                // Wert von Alarm 6 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ALV6") return percentmask(alarmvals[6]);                // Wert von Alarm 7 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "ALV7") return percentmask(alarmvals[7]);                // Wert von Alarm 8 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SOUNENAB") return sound_enab? checked: "";              // wenn Sound aktiviert -> Checkbox aktivieren
  if (var == "SOUNGONG") return sound_gong? checked: "";              // wenn Stundengong aktiviert -> Checkbox aktivieren
  if (var == "SOUNSTIM") return String(sound_stim);                   // Sound-Beginnzeit einsetzen
  if (var == "SOUNETIM") return String(sound_etim);                   // Sound-Endezeit einsetzen
  if (var == "SOUNVOLU") return String(sound_volu);                   // Lautstärke einsetzen
  if (var == "TEM1") return weathervals[0][0]? weathervals[0]: "X.X"; // Wetterdaten, Temperatur mit Nachkommastelle einsetzen
  if (var == "TEM2") return weathervals[1][0]? weathervals[1]: "X";   // Wetterdaten, Temperatur ohne Nachkommastelle einsetzen
  if (var == "HUMI") return weathervals[2][0]? weathervals[2]: "X";   // Wetterdaten, Luftfeuchtigkeit einsetzen
  if (var == "PRES") return weathervals[3][0]? weathervals[3]: "X";   // Wetterdaten, Luftdruck einsetzen
  if (var == "WIN1") return weathervals[4][0]? weathervals[4]: "X.X"; // Wetterdaten, Windgeschwindigkeit in m/s einsetzen
  if (var == "WIN2") return weathervals[5][0]? weathervals[5]: "X";   // Wetterdaten, Windgeschwindigkeit in km/h einsetzen
  if (var == "RAI1") return weathervals[6][0]? weathervals[6]: "X.X"; // Wetterdaten, Regenmenge mit Nachkommastelle einsetzen
  if (var == "RAI2") return weathervals[7][0]? weathervals[7]: "X";   // Wetterdaten, Regenmenge ohne Nachkommastelle einsetzen
  if (var == "CLOU") return weathervals[8][0]? weathervals[8]: "X";   // Wetterdaten, Wolkendichte einsetzen
  if (var == "WINS") return weathervals[9][0]? weathervals[9]: "";    // Wetterdaten, Windsymbol einsetzen
  if (var == "WEAS" && weathervals[10][0]) {                          // Wetterdaten, Wettersymbol
    s = weathervals[10];                                              // Wettersymbol als String zwischenspeichern
    i = weathervals[10][1];                                           // Wettersymbolname als ASCII-Wert holen
    if (nightsymbol) i ++;                                            // wenn Nachtmodus -> auf Nachtsymbol ändern
    return s.substring(0, 1) + char(i);                               // vollständiges Wettersymbol einsetzen
  }
  if (var == "WTXT" && weathervals[11][0]) return " " + String(weathervals[11]); // Wetterlagentext-Nummer einsetzen
  if (var == "SUNT" && weathervals[12][0]) {                          // wenn Wetterdaten, Sonnenwerte vorhanden
    s = weathervals[12];                                              // Sonnenwerte zwischenspeichern
    return s.substring(0, 5) + "&#9728;" + s.substring(7);            // mit HTML-Symbol neu zusammensetzen und zurückgeben
  }
  if (var == "FUE1") return fuelvals[0][0]? fuelvals[0]: "X.XX";      // Kraftstoffpreis 1 einsetzen
  if (var == "FUE2") return fuelvals[1][0]? fuelvals[1]: "X.XX";      // Kraftstoffpreis 2 einsetzen
  if (var == "FUE3") return fuelvals[2][0]? fuelvals[2]: "X.XX";      // Kraftstoffpreis 3 einsetzen
  if (var == "FUE4") return fuelvals[3][0]? fuelvals[3]: "X.XX";      // Kraftstoffpreis 4 einsetzen
  if (var == "BNOW") return String(bdaysnow);                         // heutige Geburtstage einsetzen
  return percentmask(String());                                       // ersetzten String zurückgeben (mit Prozentzeichen-Maskierung)
}

// Liste für Datei-Manager erstellen
void filedir() {
  filecount = 0;                                                      // Dateizähler löschen
  filelist = "";                                                      // Dateiliste löschen
  if (filestat) {                                                     // wenn Dateisystem vorhanden
    File dir = LittleFS.open("/");                                    // Hauptverzeichnis öffnen
    if (dir) {                                                        // wenn Dateien vorhanden sind
      dir.rewindDirectory();                                          // Verzeichnis bei erster Datei beginnen
      File file = dir.openNextFile();                                 // nächste Datei auswählen
      while (file) {                                                  // solange weitere Dateien vorhanden sind
        filenames[filecount] = (String(file.name()).startsWith("/")? String(file.name()).substring(1): file.name()); // Datei- oder Verzeichnisname speichern
        filesize = file.size();                                       // Dateigröße speichern
        time_t fdate = file.getLastWrite();                           // Dateizeit speichen (letzter Schreibzugriff)
        struct tm *tmstruct = localtime(&fdate);                      // strukturierte Dateizeit erstellen
        sprintf(filedate, "%02d.%02d.%d %02d:%02d:%02d", tmstruct->tm_mday, (tmstruct->tm_mon) + 1, (tmstruct->tm_year) + 1900, tmstruct->tm_hour, tmstruct->tm_min, tmstruct->tm_sec);
        filelist += F("    <tr class=\"cc\"><td>");                   // Dateiliste erstellen, neue Tabellenzeile
        filelist += filecount + 1;                                    // Dateiliste erstellen, Dateinummer
        filelist += F("</td><td class=\"le\">");                      // Dateiliste erstellen, neue Tabellenspalte
        filelist += filenames[filecount];                             // Dateiliste erstellen, Dateiname
        filelist += F("</td><td>");                                   // Dateiliste erstellen, neue Tabellenspalte
        filelist += filesize;                                         // Dateiliste erstellen, Dateigröße
        filelist += F("</td><td>");                                   // Dateiliste erstellen, neue Tabellenspalte
        filelist += filedate;                                         // Dateiliste erstellen, Dateizeit
        filelist += F("</td></tr>\n");                                // Dateiliste erstellen, Ende Tabellenzeile
        file = dir.openNextFile();                                    // nächste Datei auswählen
        filecount ++;                                                 // Dateizähler erhöhen
      }
      dir.close();                                                    // Verzeichnis schließen
    }
  }
  if (filecount == 0) {                                               // wenn keine Dateien vorhanden
    filelist += F("    <tr class=\"cc\"><td colspan=\"4\">&lt;leer&gt;</td></tr>\n"); // leere Tabellenzeile erzeugen
  }
}

void bdaylister() {
  uint8_t i;                                                          // Zählervariable
  uint8_t start = MAXBPAGE * bdaypage;                                // Listenanfang berechnen
  uint8_t end = start + MAXBPAGE;                                     // Listenende berechnen
  bdaylist = "";                                                      // Geburtstagsliste löschen
  
  for (i = start; i < end; i ++) {                                    // Listenbereich bearbeiten
    if (i >= MAXBDAYS) break;                                         // wenn Ende der Liste erreicht -> Ende
    if (birthdays[i] == "") break;                                    // wenn leerer Eintrag -> Ende
    else {                                                            // wenn Eintrag mit Daten
      bdaylist += F("    <tr class=\"cc\"><td>");                     // Geburtstagsliste erstellen, neue Tabellenzeile
      bdaylist += i + 1;                                              // Geburtstagsliste erstellen, Eintragnummer
      bdaylist += F("</td><td>");                                     // Geburtstagsliste erstellen, neue Tabellenspalte
      bdaylist += birthdays[i].substring(6, 8) + "." + birthdays[i].substring(4, 6) + "." + birthdays[i].substring(0, 4); // Geburtstagsliste erstellen, lesbares Datum
      bdaylist += F("</td><td colspan=\"2\" class=\"le\">");          // Geburtstagsliste erstellen, neue Tabellenspalte
      bdaylist += percentmask(birthdays[i].substring(9));             // Geburtstagsliste erstellen, Name (mit Prozentzeichen-Maskierung)
      bdaylist += F("</td></tr>\n");                                  // Geburtstagsliste erstellen, Ende Tabellenzeile
    }
  }
  if (bdaycount == 0) {                                               // wenn keine Geburtstage vorhanden
    bdaylist = F("    <tr class=\"cc\"><td colspan=\"4\">&lt;leer&gt;</td></tr>\n"); // leere Tabellenzeile erzeugen
  }
}
